/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.ContributionRecordHandler;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.PersonalProfileHandler;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.UserIdentityHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class CommunityProfileServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.COMMUNITY_PROFILE_OMAS;
    private PersonalProfileHandler personalProfileHandler;
    private UserIdentityHandler userIdentityHandler;
    private ContributionRecordHandler contributionRecordHandler;

    public CommunityProfileServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize, int karmaPointPlateau) throws NewInstanceException {
        super(myDescription.getAccessServiceName() + " OMAS", repositoryConnector, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            CommunityProfileErrorCode errorCode = CommunityProfileErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.personalProfileHandler = new PersonalProfileHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.errorHandler);
        this.userIdentityHandler = new UserIdentityHandler(this.serviceName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.errorHandler);
        this.contributionRecordHandler = new ContributionRecordHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, karmaPointPlateau);
    }

    public PersonalProfileHandler getPersonalProfileHandler() {
        return this.personalProfileHandler;
    }

    public UserIdentityHandler getUserIdentityHandler() {
        return this.userIdentityHandler;
    }

    public ContributionRecordHandler getContributionRecordHandler() {
        return this.contributionRecordHandler;
    }
}

