/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.admin;

import org.odpi.openmetadata.accessservices.communityprofile.auditlog.CommunityProfileAuditCode;
import org.odpi.openmetadata.accessservices.communityprofile.intopic.CommunityProfileInTopicProcessor;
import org.odpi.openmetadata.accessservices.communityprofile.omrstopic.CommunityProfileOMRSTopicProcessor;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class CommunityProfileAdmin
extends AccessServiceAdmin {
    private OMRSAuditLog auditLog = null;
    private CommunityProfileServicesInstance instance = null;
    private String serverName = null;
    private CommunityProfileInTopicProcessor inTopicProcessor = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        CommunityProfileAuditCode auditCode = CommunityProfileAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.instance = new CommunityProfileServicesInstance(repositoryConnector, super.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog), auditLog, serverUserName, repositoryConnector.getMaxPageSize(), super.extractKarmaPointPlateau(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog));
            this.serverName = this.instance.getServerName();
            if (omrsTopicConnector != null) {
                auditCode = CommunityProfileAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC;
                auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
                OpenMetadataTopicConnector outTopicConnector = null;
                if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                    outTopicConnector = super.getOutTopicEventBusConnector(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceFullName(), auditLog);
                }
                CommunityProfileOMRSTopicProcessor omrsTopicProcessor = new CommunityProfileOMRSTopicProcessor(outTopicConnector, super.extractKarmaPointIncrement(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceFullName(), serverUserName, auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_TOPIC_LISTENER), repositoryConnector.getRepositoryHelper(), this.instance);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicProcessor, auditLog);
            }
            if (accessServiceConfig.getAccessServiceInTopic() != null) {
                this.inTopicProcessor = new CommunityProfileInTopicProcessor(super.getInTopicEventBusConnector(accessServiceConfig.getAccessServiceInTopic(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceFullName(), auditLog), this.instance);
            }
            this.auditLog = auditLog;
            auditCode = CommunityProfileAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditCode = CommunityProfileAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.inTopicProcessor != null) {
            this.inTopicProcessor.shutdown();
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        CommunityProfileAuditCode auditCode = CommunityProfileAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

