/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.properties.Classification;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommunityProfileElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommunityProfileElementConverter {
    private static final String unknownProvenance = "<Unknown>";
    EntityDetail entity;
    Relationship relationship = null;
    OMRSRepositoryHelper repositoryHelper;
    String serviceName;

    CommunityProfileElementConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.entity = entity;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    CommunityProfileElementConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.entity = entity;
        this.relationship = relationship;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    void updateBean(CommunityProfileElementHeader bean) {
        if (this.entity != null) {
            InstanceType instanceType = this.entity.getType();
            if (instanceType != null) {
                bean.setTypeName(instanceType.getTypeDefName());
                bean.setTypeDescription(instanceType.getTypeDefDescription());
            }
            bean.setOriginId(this.entity.getMetadataCollectionId());
            bean.setOriginName(this.entity.getMetadataCollectionName());
            if (this.entity.getInstanceProvenanceType() != null) {
                bean.setOriginType(this.entity.getInstanceProvenanceType().getName());
            } else {
                bean.setOriginType(unknownProvenance);
            }
            bean.setOriginLicense(this.entity.getInstanceLicense());
        }
    }

    List<Classification> getClassificationsFromEntity() {
        List entityClassifications;
        ArrayList classifications = null;
        if (this.entity != null && (entityClassifications = this.entity.getClassifications()) != null) {
            classifications = new ArrayList();
            for (org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                Classification beanClassification = new Classification();
                beanClassification.setName(entityClassification.getName());
                beanClassification.setProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
            }
        }
        return classifications;
    }
}

