/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.builders.PersonalProfileBuilder;
import org.odpi.openmetadata.accessservices.communityprofile.converters.PersonalProfileConverter;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.ContactMethodHandler;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.UserIdentityHandler;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentity;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalProfileHandler {
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileHandler.class);
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private UserIdentityHandler userIdentityHandler;
    private ContactMethodHandler contactMethodHandler;

    public PersonalProfileHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, RepositoryErrorHandler errorHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.userIdentityHandler = new UserIdentityHandler(serviceName, invalidParameterHandler, repositoryHelper, repositoryHandler, errorHandler);
        this.contactMethodHandler = new ContactMethodHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler, errorHandler);
    }

    public PersonalProfile getPersonalProfile(String userId, EntityDetail personalProfileEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<UserIdentity> associatedUserIds = this.userIdentityHandler.getAssociatedUserIds(userId, personalProfileEntity.getGUID(), methodName);
        List<ContactMethod> contactMethods = this.contactMethodHandler.getContactMethods(userId, personalProfileEntity.getGUID(), methodName);
        PersonalProfileConverter converter = new PersonalProfileConverter(personalProfileEntity, associatedUserIds, contactMethods, this.repositoryHelper, this.serviceName);
        return converter.getBean();
    }

    public PersonalProfile getPersonalProfile(String userId, String profileUserId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail personalProfileEntity;
        String guidParameterName = "profileUserId";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileUserId, "profileUserId", methodName);
        String userIdentityGUID = this.userIdentityHandler.getUserIdentityGUID(userId, profileUserId, methodName);
        if (userIdentityGUID != null && (personalProfileEntity = this.repositoryHandler.getEntityForRelationshipType(userId, userIdentityGUID, "UserIdentity", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", methodName)) != null) {
            return this.getPersonalProfile(userId, personalProfileEntity, methodName);
        }
        return null;
    }

    public String createPersonalProfile(String userId, String profileUserId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        PersonalProfileBuilder builder = new PersonalProfileBuilder(employeeNumber, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getPersonEntityProperties(knownName, fullName, jobTitle, jobRoleDescription);
        String profileGUID = this.repositoryHandler.createEntity(userId, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", properties, methodName);
        this.userIdentityHandler.addIdentityToProfile(userId, profileGUID, profileUserId, methodName);
        log.debug("Creation of personal details successful: " + profileGUID);
        return profileGUID;
    }

    public void updatePersonalProfile(String userId, String profileGUID, String qualifiedName, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> extendedProperties, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        PersonalProfileBuilder builder = new PersonalProfileBuilder(qualifiedName, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getPersonEntityProperties(knownName, fullName, jobTitle, jobRoleDescription);
        this.repositoryHandler.updateEntity(userId, profileGUID, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", properties, methodName);
        log.debug("Update of personal details successful: " + profileGUID);
    }

    public void deletePersonalProfile(String userId, String profileGUID, String qualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "profileGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.repositoryHandler.removeEntity(userId, profileGUID, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", "qualifiedName", qualifiedName, methodName);
        log.debug("Delete of personal details successful: " + profileGUID);
    }

    private PersonalProfile getPersonalProfileBean(String userId, EntityDetail entity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (entity != null) {
            List<UserIdentity> associatedUserIds = this.userIdentityHandler.getAssociatedUserIds(userId, entity.getGUID(), methodName);
            List<ContactMethod> contactDetails = this.contactMethodHandler.getContactMethods(userId, entity.getGUID(), methodName);
            PersonalProfileConverter converter = new PersonalProfileConverter(entity, associatedUserIds, contactDetails, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "profileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, "profileGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, profileGUID, "profileGUID", "Person", methodName);
        return this.getPersonalProfileBean(userId, entity, methodName);
    }

    public PersonalProfile getPersonalProfileByQualifiedName(String userId, String qualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String employeeNumberParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        PersonalProfileBuilder builder = new PersonalProfileBuilder(qualifiedName, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getQualifiedNameInstanceProperties(methodName);
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", methodName);
        return this.getPersonalProfileBean(userId, entity, methodName);
    }

    public List<PersonalProfile> getPersonalProfilesByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        PersonalProfileBuilder builder = new PersonalProfileBuilder(null, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getNameInstanceProperties(methodName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, properties, "ac406bf8-e53e-49f1-9088-2af28bbbd285", startFrom, pageSize, methodName);
        if (entities != null) {
            ArrayList<PersonalProfile> personalProfiles = new ArrayList<PersonalProfile>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                personalProfiles.add(this.getPersonalProfileBean(userId, entity, methodName));
            }
            if (!personalProfiles.isEmpty()) {
                return personalProfiles;
            }
        }
        return null;
    }
}

