/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethod;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactMethodConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(ContactMethod.class);

    public ContactMethodConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, repositoryHelper, serviceName);
    }

    public ContactMethod getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        ContactMethod bean = new ContactMethod();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setType(this.getContactMethodTypeFromProperties(instanceProperties));
            bean.setService(this.repositoryHelper.getStringProperty(this.serviceName, "contactMethodService", instanceProperties, "getBean"));
            bean.setValue(this.repositoryHelper.getStringProperty(this.serviceName, "contactMethodValue", instanceProperties, "getBean"));
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }

    private ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null && (instancePropertyValue = properties.getPropertyValue("contactMethodType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
                case 99: {
                    contactMethodType = ContactMethodType.OTHER;
                }
            }
        }
        log.debug("ContactMethodType: " + contactMethodType.getName());
        return contactMethodType;
    }
}

