/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ContactMethodElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodType;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactMethodConverter<B>
extends CommunityProfileOMASConverter<B> {
    private static final Logger log = LoggerFactory.getLogger(ContactMethodProperties.class);

    public ContactMethodConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ContactMethodElement) {
                ContactMethodElement bean = (ContactMethodElement)returnBean;
                ContactMethodProperties contactMethodProperties = new ContactMethodProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    contactMethodProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    contactMethodProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    contactMethodProperties.setType(this.getContactMethodTypeFromProperties(instanceProperties));
                    contactMethodProperties.setService(this.removeContactMethodService(instanceProperties));
                    contactMethodProperties.setValue(this.removeContactMethodValue(instanceProperties));
                    contactMethodProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    contactMethodProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(contactMethodProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        String methodName = "getContactMethodTypeFromProperties";
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "contactMethodType", properties, "getContactMethodTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
                case 99: {
                    contactMethodType = ContactMethodType.OTHER;
                }
            }
        }
        return contactMethodType;
    }
}

