/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContributionRecord;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ContributionRecordConverter<B>
extends CommunityProfileOMASConverter<B> {
    private int karmaPointPlateau;

    public ContributionRecordConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, int karmaPointPlateau) {
        super(repositoryHelper, serviceName, serverName);
        this.karmaPointPlateau = karmaPointPlateau;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ContributionRecordElement) {
                ContributionRecordElement bean = (ContributionRecordElement)returnBean;
                ContributionRecord contributionRecord = new ContributionRecord();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    contributionRecord.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    contributionRecord.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    contributionRecord.setKarmaPoints(this.removeKarmaPoints(instanceProperties));
                    contributionRecord.setKarmaPointPlateau(this.karmaPointPlateau);
                    contributionRecord.setTypeName(bean.getElementHeader().getType().getTypeName());
                    contributionRecord.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(contributionRecord);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

