/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.MetadataSourceElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.MetadataSourceProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class MetadataSourceConverter<B>
extends CommunityProfileOMASConverter<B> {
    public MetadataSourceConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof MetadataSourceElement) {
                MetadataSourceElement bean = (MetadataSourceElement)returnBean;
                MetadataSourceProperties metadataSourceProperties = new MetadataSourceProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    metadataSourceProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    metadataSourceProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    metadataSourceProperties.setDisplayName(this.removeName(instanceProperties));
                    metadataSourceProperties.setDescription(this.removeDescription(instanceProperties));
                    metadataSourceProperties.setTypeDescription(this.removeDeployedImplementationType(instanceProperties));
                    metadataSourceProperties.setVersion(this.removeCapabilityVersion(instanceProperties));
                    metadataSourceProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    metadataSourceProperties.setSource(this.removeSource(instanceProperties));
                    metadataSourceProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    metadataSourceProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(metadataSourceProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

