/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfileProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonalProfileConverter<B>
extends CommunityProfileOMASConverter<B> {
    public PersonalProfileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (!(returnBean instanceof PersonalProfileUniverse)) return returnBean;
            PersonalProfileUniverse bean = (PersonalProfileUniverse)returnBean;
            PersonalProfileProperties profileProperties = new PersonalProfileProperties();
            if (primaryEntity != null) {
                bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                profileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                profileProperties.setKnownName(this.removeName(instanceProperties));
                profileProperties.setDescription(this.removeDescription(instanceProperties));
                profileProperties.setFullName(this.removeFullName(instanceProperties));
                profileProperties.setJobTitle(this.removeJobTitle(instanceProperties));
                profileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                profileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                profileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                bean.setProfileProperties(profileProperties);
                if (relationships == null) return returnBean;
            }
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

