/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.omrstopic;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileAuditCode;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.outtopic.CommunityProfileOutTopicProcessor;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileServicesInstance;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContributionRecordHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityProfileOMRSTopicProcessor
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(CommunityProfileOMRSTopicProcessor.class);
    private CommunityProfileOutTopicProcessor publisher;
    private OMRSRepositoryHelper repositoryHelper;
    private int karmaPointIncrement;
    private UserIdentityHandler<UserIdentityElement> userIdentityHandler;
    private ActorProfileHandler<PersonalProfileUniverse> personalProfileHandler;
    private ContributionRecordHandler<ContributionRecordElement> contributionRecordHandler;
    private String serverUserId;

    public CommunityProfileOMRSTopicProcessor(OpenMetadataTopicConnector communityProfileOutTopic, int karmaPointIncrement, String serviceName, String serverUserId, AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, CommunityProfileServicesInstance instance) throws PropertyServerException {
        super(serviceName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.publisher = new CommunityProfileOutTopicProcessor(communityProfileOutTopic, instance.getInvalidParameterHandler(), auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC));
        this.karmaPointIncrement = karmaPointIncrement;
        this.personalProfileHandler = instance.getPersonalProfileHandler();
        this.contributionRecordHandler = instance.getContributionRecordHandler();
        this.userIdentityHandler = instance.getUserIdentityHandler();
        this.serverUserId = serverUserId;
    }

    private void awardKarmaPoints(InstanceHeader contribution) {
        String methodName = "awardKarmaPoints";
        String userParameterName = "contribution.getUpdatedBy";
        if (this.karmaPointIncrement > 0 && contribution != null) {
            String contributingUserId = contribution.getUpdatedBy();
            if (contributingUserId == null) {
                contributingUserId = contribution.getCreatedBy();
            }
            try {
                List personalProfiles = this.personalProfileHandler.getActorProfileByName(this.serverUserId, contributingUserId, "contribution.getUpdatedBy", 0, 0, "awardKarmaPoints");
                if (personalProfiles != null && personalProfiles.size() == 1) {
                    String profileGUIDParameterName = "personalProfiles.get(0).getElementHeader().getGUID()";
                    ContributionRecordElement contributionRecord = ((PersonalProfileUniverse)personalProfiles.get(0)).getContributionRecord();
                    int currentPlateau = contributionRecord.getProperties().getKarmaPointPlateau();
                    contributionRecord = (ContributionRecordElement)this.contributionRecordHandler.incrementKarmaPoints(this.serverUserId, ((PersonalProfileUniverse)personalProfiles.get(0)).getElementHeader().getGUID(), "personalProfiles.get(0).getElementHeader().getGUID()", ((PersonalProfileUniverse)personalProfiles.get(0)).getProfileProperties().getQualifiedName(), this.karmaPointIncrement, "awardKarmaPoints");
                    log.debug("Karma points updated: " + contributingUserId);
                    if (contributionRecord.getProperties().getKarmaPointPlateau() > currentPlateau) {
                        this.auditLog.logMessage("awardKarmaPoints", CommunityProfileAuditCode.KARMA_PLATEAU_AWARD.getMessageDefinition(new String[]{contributingUserId, Integer.toString(contributionRecord.getProperties().getKarmaPointPlateau()), Integer.toString(contributionRecord.getProperties().getKarmaPoints())}));
                        this.publisher.sendKarmaPointPlateauEvent((PersonalProfileUniverse)personalProfiles.get(0), contributingUserId, contributionRecord.getProperties().getKarmaPointPlateau(), contributionRecord.getProperties().getKarmaPoints());
                    }
                }
            }
            catch (Exception error) {
                this.auditLog.logException("awardKarmaPoints", CommunityProfileAuditCode.KARMA_POINT_EXCEPTION.getMessageDefinition(new String[]{contributingUserId, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        String guidParameterName = "newEntityEvent.getGUID";
        log.debug("Processing new Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)entity, "processNewEntityEvent");
        if (instanceTypeName != null) {
            try {
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "Person")) {
                    this.publisher.sendNewPersonalProfileEvent((PersonalProfileUniverse)this.personalProfileHandler.getActorProfileByGUID(this.serverUserId, entity.getGUID(), "newEntityEvent.getGUID", "processNewEntityEvent"));
                } else if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "UserIdentity")) {
                    this.publisher.sendNewUserIdentityEvent((UserIdentityElement)this.userIdentityHandler.getUserIdentityByGUID(this.serverUserId, entity.getGUID(), "newEntityEvent.getGUID", "processNewEntityEvent"));
                }
            }
            catch (Exception error) {
                this.auditLog.logException("processNewEntityEvent", CommunityProfileAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{entity.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        log.debug("Processing updated Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)newEntity);
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing undone Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        log.debug("Processing classified Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing deleted Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        log.debug("Processing purged Entity event from: " + sourceName);
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing delete-purge entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing restored Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        log.debug("Processing re-identified Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        log.debug("Processing re-typed Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        log.debug("Processing re-homed Entity event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)entity);
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing new relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        log.debug("Processing updated relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)newRelationship);
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing undone relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing deleted relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        log.debug("Processing purged relationship event from: " + sourceName);
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing delete-purge relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing restored relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        log.debug("Processing re-identified relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        log.debug("Processing re-typed relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        log.debug("Processing re-homed relationship event from: " + sourceName);
        this.awardKarmaPoints((InstanceHeader)relationship);
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        log.debug("Processing instance batch event from: " + sourceName);
        if (instances != null) {
            List entities = instances.getEntities();
            List relationships = instances.getRelationships();
            if (entities != null) {
                for (EntityDetail entity : entities) {
                    if (entity == null) continue;
                    this.processNewEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
                }
            }
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    this.processNewRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
                }
            }
        }
    }
}

