/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.outtopic;

import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileAuditCode;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.topics.CommunityProfileOutTopicPublisher;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;

public class CommunityProfileOutTopicProcessor
extends CommunityProfileOutTopicPublisher {
    private InvalidParameterHandler invalidParameterHandler;
    private AuditLog auditLog;

    public CommunityProfileOutTopicProcessor(OpenMetadataTopicConnector connector, InvalidParameterHandler invalidParameterHandler, AuditLog auditLog) {
        super(connector, invalidParameterHandler);
        this.invalidParameterHandler = invalidParameterHandler;
        this.auditLog = auditLog;
    }

    private void logOutboundEvent(String actionDescription, String eventTypeName, String subjectGUID) {
        if (this.auditLog != null) {
            this.auditLog.logMessage(actionDescription, CommunityProfileAuditCode.OUTBOUND_EVENT.getMessageDefinition(new String[]{eventTypeName, subjectGUID}));
        }
    }

    public void sendNewUserIdentityEvent(UserIdentityElement bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewUserIdentityEvent");
        this.logOutboundEvent("sendNewUserIdentityEvent", CommunityProfileOutboundEventType.NEW_USER_IDENTITY_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewUserIdentityEvent(bean);
    }

    public void sendNewExternalUserIdentityEvent(UserIdentityElement bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewExternalUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewExternalUserIdentityEvent");
        this.logOutboundEvent("sendNewExternalUserIdentityEvent", CommunityProfileOutboundEventType.NEW_REF_USER_IDENTITY_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewExternalUserIdentityEvent(bean);
    }

    public void sendUpdatedUserIdentityEvent(UserIdentityElement bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendUpdatedUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendUpdatedUserIdentityEvent");
        this.logOutboundEvent("sendUpdatedUserIdentityEvent", CommunityProfileOutboundEventType.UPDATED_USER_IDENTITY_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendUpdatedUserIdentityEvent(bean);
    }

    public void sendDeletedUserIdentityEvent(UserIdentityElement bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendDeletedUserIdentityEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendDeletedUserIdentityEvent");
        this.logOutboundEvent("sendDeletedUserIdentityEvent", CommunityProfileOutboundEventType.DELETED_USER_IDENTITY_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendDeletedUserIdentityEvent(bean);
    }

    public void sendNewPersonalProfileEvent(PersonalProfileUniverse bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewPersonalProfileEvent");
        this.logOutboundEvent("sendNewPersonalProfileEvent", CommunityProfileOutboundEventType.NEW_PERSONAL_PROFILE_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewPersonalProfileEvent(bean);
    }

    public void sendNewExternalPersonalProfileEvent(PersonalProfileUniverse bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewExternalPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewExternalPersonalProfileEvent");
        this.logOutboundEvent("sendNewExternalPersonalProfileEvent", CommunityProfileOutboundEventType.NEW_REF_PERSONAL_PROFILE_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewExternalPersonalProfileEvent(bean);
    }

    public void sendUpdatedPersonalProfileEvent(PersonalProfileUniverse bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendUpdatedPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendUpdatedPersonalProfileEvent");
        this.logOutboundEvent("sendUpdatedPersonalProfileEvent", CommunityProfileOutboundEventType.UPDATED_PERSONAL_PROFILE_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendUpdatedPersonalProfileEvent(bean);
    }

    public void sendDeletedPersonalProfileEvent(PersonalProfileUniverse bean) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendDeletedPersonalProfileEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendDeletedPersonalProfileEvent");
        this.logOutboundEvent("sendDeletedPersonalProfileEvent", CommunityProfileOutboundEventType.DELETED_PERSONAL_PROFILE_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendDeletedPersonalProfileEvent(bean);
    }

    public void sendKarmaPointPlateauEvent(PersonalProfileUniverse bean, String userId, int plateau, int totalPoints) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendKarmaPointPlateauEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendKarmaPointPlateauEvent");
        this.logOutboundEvent("sendKarmaPointPlateauEvent", CommunityProfileOutboundEventType.KARMA_POINT_PLATEAU_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendKarmaPointPlateauEvent(bean, userId, plateau, totalPoints);
    }

    public void sendNewAssetInCollectionEvent(PersonalProfileUniverse bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewAssetInCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewAssetInCollectionEvent");
        this.logOutboundEvent("sendNewAssetInCollectionEvent", CommunityProfileOutboundEventType.NEW_ASSET_IN_COLLECTION_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewAssetInCollectionEvent(bean, userId, memberGUID, memberTypeName);
    }

    public void sendAssetRemovedFromCollectionEvent(PersonalProfileUniverse bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendAssetRemovedFromCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendAssetRemovedFromCollectionEvent");
        this.logOutboundEvent("sendAssetRemovedFromCollectionEvent", CommunityProfileOutboundEventType.ASSET_REMOVED_FROM_COLLECTION_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendAssetRemovedFromCollectionEvent(bean, userId, memberGUID, memberTypeName);
    }

    public void sendNewProjectInCollectionEvent(PersonalProfileUniverse bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewProjectInCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewProjectInCollectionEvent");
        this.logOutboundEvent("sendNewProjectInCollectionEvent", CommunityProfileOutboundEventType.NEW_PROJECT_IN_COLLECTION_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewProjectInCollectionEvent(bean, userId, memberGUID, memberTypeName);
    }

    public void sendProjectRemovedFromCollectionEvent(PersonalProfileUniverse bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendProjectRemovedFromCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendProjectRemovedFromCollectionEvent");
        this.logOutboundEvent("sendProjectRemovedFromCollectionEvent", CommunityProfileOutboundEventType.PROJECT_REMOVED_FROM_COLLECTION_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendProjectRemovedFromCollectionEvent(bean, userId, memberGUID, memberTypeName);
    }

    public void sendNewCommunityInCollectionEvent(PersonalProfileUniverse bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendNewCommunityInCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendNewCommunityInCollectionEvent");
        this.logOutboundEvent("sendNewCommunityInCollectionEvent", CommunityProfileOutboundEventType.NEW_COMMUNITY_IN_COLLECTION_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendNewCommunityInCollectionEvent(bean, userId, memberGUID, memberTypeName);
    }

    public void sendCommunityRemovedFromCollectionEvent(PersonalProfileUniverse bean, String userId, String memberGUID, String memberTypeName) throws InvalidParameterException, ConnectorCheckedException {
        String parameterName = "bean";
        String methodName = "sendCommunityRemovedFromCollectionEvent";
        this.invalidParameterHandler.validateObject((Object)bean, "bean", "sendCommunityRemovedFromCollectionEvent");
        this.logOutboundEvent("sendCommunityRemovedFromCollectionEvent", CommunityProfileOutboundEventType.COMMUNITY_REMOVED_FROM_COLLECTION_EVENT.getEventTypeName(), bean.getElementHeader().getGUID());
        super.sendCommunityRemovedFromCollectionEvent(bean, userId, memberGUID, memberTypeName);
    }
}

