/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.HashMap;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.LoggerFactory;

public class PersonalProfileRESTServices {
    private static CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(PersonalProfileRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createPersonalProfile(String serverName, String userId, PersonalProfileRequestBody requestBody) {
        String methodName = "createPersonalProfile";
        String profileGUIDParameterName = "profileGUID";
        String userParameterName = "requestBody.getProfileUserId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createPersonalProfile");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ActorProfileHandler<PersonalProfileUniverse> profileHandler = instanceHandler.getPersonalProfileHandler(userId, serverName, "createPersonalProfile");
                UserIdentityHandler<UserIdentityElement> userIdentityHandler = instanceHandler.getUserIdentityHandler(userId, serverName, "createPersonalProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createPersonalProfile");
                EntityDetail userIdentity = userIdentityHandler.getEntityByUniqueQualifiedName(userId, "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", requestBody.getProfileUserId(), "requestBody.getProfileUserId", "createPersonalProfile");
                HashMap<String, String> extendedProperties = new HashMap<String, String>();
                extendedProperties.put("fullName", requestBody.getFullName());
                extendedProperties.put("jobTitle", requestBody.getJobTitle());
                String profileGUID = profileHandler.createActorProfile(userId, requestBody.getOriginatingSystemGUID(), requestBody.getOriginatingSystemName(), requestBody.getQualifiedName(), requestBody.getKnownName(), requestBody.getJobRoleDescription(), requestBody.getAdditionalProperties(), "Person", extendedProperties, "createPersonalProfile");
                if (userIdentity == null) {
                    userIdentityHandler.createUserIdentity(userId, requestBody.getOriginatingSystemGUID(), requestBody.getOriginatingSystemName(), profileGUID, "profileGUID", requestBody.getProfileUserId(), null, null, null, "createPersonalProfile");
                } else {
                    userIdentityHandler.linkElementToElement(userId, requestBody.getOriginatingSystemGUID(), requestBody.getOriginatingSystemName(), profileGUID, "profileGUID", "ActorProfile", userIdentity.getGUID(), "requestBody.getProfileUserId", "UserIdentity", "01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", null, "createPersonalProfile");
                }
                response.setGUID(profileGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createPersonalProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createPersonalProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updatePersonalProfile(String serverName, String userId, String profileGUID, PersonalProfileRequestBody requestBody) {
        String methodName = "updatePersonalProfile";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updatePersonalProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                HashMap<String, String> extendedProperties = new HashMap<String, String>();
                extendedProperties.put("fullName", requestBody.getFullName());
                extendedProperties.put("jobTitle", requestBody.getJobTitle());
                ActorProfileHandler<PersonalProfileUniverse> handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "updatePersonalProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updatePersonalProfile");
                handler.updateActorProfile(userId, requestBody.getOriginatingSystemGUID(), requestBody.getOriginatingSystemName(), profileGUID, "profileGUID", requestBody.getQualifiedName(), requestBody.getKnownName(), requestBody.getJobRoleDescription(), requestBody.getAdditionalProperties(), "Person", extendedProperties, false, "updatePersonalProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updatePersonalProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updatePersonalProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deletePersonalProfile(String serverName, String userId, String profileGUID, PersonalProfileValidatorRequestBody requestBody) {
        String methodName = "deletePersonalProfile";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deletePersonalProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ActorProfileHandler<PersonalProfileUniverse> handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "deletePersonalProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deletePersonalProfile");
                handler.removeActorProfile(userId, requestBody.getOriginatingSystemGUID(), requestBody.getOriginatingSystemName(), profileGUID, "profileGUID", "deletePersonalProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deletePersonalProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deletePersonalProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileForUser(String serverName, String userId, String profileUserId) {
        String methodName = "getPersonalProfileForUser";
        String userParameterName = "profileUserId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonalProfileForUser");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<PersonalProfileUniverse> handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfileForUser");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfileForUser");
            response.setPersonalProfile((PersonalProfileUniverse)handler.getActorProfileForUser(userId, profileUserId, "profileUserId", "getPersonalProfileForUser"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonalProfileForUser", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByGUID(String serverName, String userId, String profileGUID) {
        String methodName = "getPersonalProfileByGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonalProfileByGUID");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<PersonalProfileUniverse> handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfileByGUID");
            response.setPersonalProfile((PersonalProfileUniverse)handler.getActorProfileByGUID(userId, profileGUID, "profileGUID", "getPersonalProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonalProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByQualifiedName(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "getPersonalProfilesByName";
        String nameParameterName = "getPersonalProfilesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonalProfilesByName");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<PersonalProfileUniverse> handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfilesByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfilesByName");
            response.setPersonalProfile((PersonalProfileUniverse)handler.getBeanByUniqueName(userId, requestBody.getName(), "getPersonalProfilesByName", requestBody.getNamePropertyName(), "ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", "getPersonalProfilesByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonalProfilesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonalProfileListResponse getPersonalProfilesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getPersonalProfilesByName";
        String nameParameterName = "getPersonalProfilesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonalProfilesByName");
        PersonalProfileListResponse response = new PersonalProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<PersonalProfileUniverse> handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfilesByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfilesByName");
            response.setPersonalProfiles(handler.getActorProfileByName(userId, requestBody.getName(), "getPersonalProfilesByName", startFrom, pageSize, "getPersonalProfilesByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonalProfilesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

