/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import org.odpi.openmetadata.accessservices.communityprofile.converters.CommonHeaderConverter;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommonHeader;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ExternalReference;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalReferenceConverter
extends CommonHeaderConverter {
    private static final Logger log = LoggerFactory.getLogger(ExternalReferenceConverter.class);

    public ExternalReferenceConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, relationship, repositoryHelper, serviceName);
    }

    public ExternalReference getBean() {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        ExternalReference bean = new ExternalReference();
        super.updateBean((CommonHeader)bean);
        if (this.entity != null && (instanceProperties = this.entity.getProperties()) != null) {
            bean.setResourceId(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
            bean.setResourceDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "getBean"));
            bean.setResourceDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setResourceURL(this.repositoryHelper.removeStringProperty(this.serviceName, "url", instanceProperties, "getBean"));
            bean.setResourceVersion(this.repositoryHelper.removeStringProperty(this.serviceName, "version", instanceProperties, "getBean"));
            bean.setOwningOrganization(this.repositoryHelper.removeStringProperty(this.serviceName, "organization", instanceProperties, "getBean"));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        if (this.relationship != null && (instanceProperties = this.relationship.getProperties()) != null) {
            bean.setLinkId(this.repositoryHelper.getStringProperty(this.serviceName, "referenceId", instanceProperties, "getBean"));
            bean.setLinkDescription(this.repositoryHelper.getStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
        }
        log.debug("Bean: " + bean.toString());
        return bean;
    }
}

