/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.handlers;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.builders.ContributionRecordBuilder;
import org.odpi.openmetadata.accessservices.communityprofile.converters.ContributionRecordConverter;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContributionRecord;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ContributionRecordHandler {
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;
    private int karmaPointPlateau;

    public ContributionRecordHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, int karmaPointPlateau) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.karmaPointPlateau = karmaPointPlateau;
    }

    private int getKarmaPointPlateau(int karmaPointTotal) {
        return karmaPointTotal / this.karmaPointPlateau;
    }

    public ContributionRecord getContributionRecord(String userId, String personalProfileGUID, String qualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "personalProfileGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(personalProfileGUID, "personalProfileGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, personalProfileGUID, "Person", "4a316abe-eeee-4d11-ad5a-4bfb4079b80b", "PersonalContribution", methodName);
        if (entity == null) {
            String contributionRecordGUID = this.addContributionRecord(userId, personalProfileGUID, qualifiedName, methodName);
            entity = this.repositoryHandler.getEntityByGUID(userId, contributionRecordGUID, "new contribution guid", "ContributionRecord", methodName);
        }
        if (entity != null) {
            ContributionRecordConverter converter = new ContributionRecordConverter(entity, this.repositoryHelper, this.serviceName);
            ContributionRecord contributionRecord = converter.getBean();
            if (contributionRecord != null && contributionRecord.getKarmaPoints() > 0) {
                contributionRecord.setKarmaPointPlateau(this.getKarmaPointPlateau(contributionRecord.getKarmaPoints()));
            }
            return contributionRecord;
        }
        throw new PropertyServerException(CommunityProfileErrorCode.UNABLE_TO_CREATE_CONTRIBUTION_RECORD.getMessageDefinition(new String[]{methodName, this.serverName, personalProfileGUID, qualifiedName}), this.getClass().getName(), methodName);
    }

    private String addContributionRecord(String userId, String personalProfileGUID, String qualifiedName, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        ContributionRecordBuilder builder = new ContributionRecordBuilder(qualifiedName, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getQualifiedNameInstanceProperties(methodName);
        String contributionRecordGUID = this.repositoryHandler.createEntity(userId, "ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", properties, methodName);
        this.repositoryHandler.createRelationship(userId, "4a316abe-eeee-4d11-ad5a-4bfb4079b80b", personalProfileGUID, contributionRecordGUID, null, methodName);
        return contributionRecordGUID;
    }

    private void saveContributionRecord(String userId, ContributionRecord contributionRecord, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ContributionRecordBuilder builder = new ContributionRecordBuilder(contributionRecord.getQualifiedName(), this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getContributionRecordProperties(contributionRecord.getKarmaPoints(), contributionRecord.getExtendedProperties(), contributionRecord.getAdditionalProperties());
        this.repositoryHandler.updateEntity(userId, contributionRecord.getGUID(), "ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", properties, methodName);
    }

    public void updateContributionRecord(String userId, String personalProfileGUID, String qualifiedName, Map<String, Object> extendedProperties, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ContributionRecord contributionRecord = this.getContributionRecord(userId, personalProfileGUID, qualifiedName, methodName);
        if (contributionRecord != null) {
            contributionRecord.setExtendedProperties(extendedProperties);
            contributionRecord.setAdditionalProperties(additionalProperties);
            this.saveContributionRecord(userId, contributionRecord, methodName);
        }
    }

    public ContributionRecord incrementKarmaPoints(String userId, String personalProfileGUID, String qualifiedName, int karmaPointIncrement, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ContributionRecord contributionRecord = this.getContributionRecord(userId, personalProfileGUID, qualifiedName, methodName);
        if (contributionRecord != null && karmaPointIncrement > 0) {
            int newKarmaPoints = contributionRecord.getKarmaPoints() + karmaPointIncrement;
            contributionRecord.setKarmaPoints(newKarmaPoints);
            this.saveContributionRecord(userId, contributionRecord, methodName);
            contributionRecord.setKarmaPointPlateau(this.getKarmaPointPlateau(newKarmaPoints));
        }
        return contributionRecord;
    }

    public void deleteContributionRecord(String userId, String personalProfileGUID, String qualifiedName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        ContributionRecord contributionRecord = this.getContributionRecord(userId, personalProfileGUID, qualifiedName, methodName);
        if (contributionRecord != null) {
            this.repositoryHandler.removeEntity(userId, contributionRecord.getGUID(), "ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", "qualifiedName", qualifiedName, methodName);
        }
    }
}

