/* SPDX-License-Identifier: Apache 2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.communityprofile.mappers;

/**
 * ToDoMapper provides property name mapping for To Dos.
 */
public class ToDoMapper
{
    public static final String QUALIFIED_NAME_PROPERTY_NAME        = "qualifiedName";        /* from Referenceable entity */
    public static final String NAME_PROPERTY_NAME                  = "name";                 /* from To Do entity */
    public static final String DESCRIPTION_PROPERTY_NAME           = "description";          /* from To Do entity */
    public static final String CREATION_TIME_PROPERTY_NAME         = "creationTime";         /* from To Do entity */
    public static final String PRIORITY_PROPERTY_NAME              = "priority";             /* from To Do entity */
    public static final String DUE_TIME_PROPERTY_NAME              = "dueTime";              /* from To Do entity */
    public static final String COMPLETION_TIME_PROPERTY_NAME       = "completionTime";       /* from To Do entity */
    public static final String STATUS_PROPERTY_NAME                = "status";               /* from To Do entity */
    public static final String ADDITIONAL_PROPERTIES_PROPERTY_NAME = "additionalProperties"; /* from Referenceable entity */
}
