/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.PersonalProfileHandler;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonalProfileRESTServices {
    private static CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(PersonalProfileRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createPersonalProfile(String serverName, String userId, PersonalProfileRequestBody requestBody) {
        String methodName = "createPersonalProfile";
        log.debug("Calling method: createPersonalProfile");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String profileUserId = null;
            String qualifiedName = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                profileUserId = requestBody.getProfileUserId();
                qualifiedName = requestBody.getQualifiedName();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "createPersonalProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createPersonalProfile");
            response.setGUID(handler.createPersonalProfile(userId, profileUserId, qualifiedName, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties, "createPersonalProfile"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createPersonalProfile", auditLog);
        }
        log.debug("Returning from method: createPersonalProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse updatePersonalProfile(String serverName, String userId, String profileGUID, PersonalProfileRequestBody requestBody) {
        String methodName = "updatePersonalProfile";
        log.debug("Calling method: updatePersonalProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String qualifiedName = null;
            String fullName = null;
            String knownName = null;
            String jobTitle = null;
            String jobRoleDescription = null;
            Map extendedProperties = null;
            Map additionalProperties = null;
            if (requestBody != null) {
                qualifiedName = requestBody.getQualifiedName();
                fullName = requestBody.getFullName();
                knownName = requestBody.getKnownName();
                jobTitle = requestBody.getJobTitle();
                jobRoleDescription = requestBody.getJobRoleDescription();
                extendedProperties = requestBody.getProfileProperties();
                additionalProperties = requestBody.getAdditionalProperties();
            }
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "updatePersonalProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updatePersonalProfile");
            handler.updatePersonalProfile(userId, profileGUID, qualifiedName, fullName, knownName, jobTitle, jobRoleDescription, extendedProperties, additionalProperties, "updatePersonalProfile");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updatePersonalProfile", auditLog);
        }
        log.debug("Returning from method: updatePersonalProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse deletePersonalProfile(String serverName, String userId, String profileGUID, PersonalProfileValidatorRequestBody requestBody) {
        String methodName = "deletePersonalProfile";
        log.debug("Calling method: deletePersonalProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String employeeNumber = null;
            if (requestBody != null) {
                employeeNumber = requestBody.getQualifiedName();
            }
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "deletePersonalProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deletePersonalProfile");
            handler.deletePersonalProfile(userId, profileGUID, employeeNumber, "deletePersonalProfile");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deletePersonalProfile", auditLog);
        }
        log.debug("Returning from method: deletePersonalProfile with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileForUser(String serverName, String userId, String profileUserId) {
        String methodName = "getPersonalProfileForUser";
        log.debug("Calling method: getPersonalProfileForUser");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(serverName, userId, "getPersonalProfileForUser");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfileForUser");
            response.setPersonalProfile(handler.getPersonalProfile(userId, profileUserId, "getPersonalProfileForUser"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getPersonalProfileForUser", auditLog);
        }
        log.debug("Returning from method: getPersonalProfileForUser with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByGUID(String serverName, String userId, String profileGUID) {
        String methodName = "getPersonalProfileByGUID";
        log.debug("Calling method: getPersonalProfileByGUID");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfileByGUID");
            response.setPersonalProfile(handler.getPersonalProfileByGUID(userId, profileGUID, "getPersonalProfileByGUID"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getPersonalProfileByGUID", auditLog);
        }
        log.debug("Returning from method: getPersonalProfileByGUID with response: " + response.toString());
        return response;
    }

    public PersonalProfileResponse getPersonalProfileByQualifiedName(String serverName, String userId, String employeeNumber) {
        String methodName = "getPersonalProfileByQualifiedName";
        log.debug("Calling method: getPersonalProfileByQualifiedName");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfileByQualifiedName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfileByQualifiedName");
            response.setPersonalProfile(handler.getPersonalProfileByQualifiedName(userId, employeeNumber, "getPersonalProfileByQualifiedName"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getPersonalProfileByQualifiedName", auditLog);
        }
        log.debug("Returning from method: getPersonalProfileByQualifiedName with response: " + response.toString());
        return response;
    }

    public PersonalProfileListResponse getPersonalProfilesByName(String serverName, String userId, String name, int startFrom, int pageSize) {
        String methodName = "getPersonalProfilesByName";
        log.debug("Calling method: getPersonalProfilesByName");
        PersonalProfileListResponse response = new PersonalProfileListResponse();
        AuditLog auditLog = null;
        try {
            PersonalProfileHandler handler = instanceHandler.getPersonalProfileHandler(userId, serverName, "getPersonalProfilesByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonalProfilesByName");
            response.setPersonalProfiles(handler.getPersonalProfilesByName(userId, name, startFrom, pageSize, "getPersonalProfilesByName"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getPersonalProfilesByName", auditLog);
        }
        log.debug("Returning from method: getPersonalProfilesByName with response: " + response.toString());
        return response;
    }
}

