/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import org.odpi.openmetadata.accessservices.communityprofile.handlers.UserIdentityHandler;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIdentityRESTServices {
    private static CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(UserIdentityRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse createUserIdentity(String serverName, String userId, UserIdentityRequestBody requestBody) {
        String methodName = "createUserIdentity";
        log.debug("Calling method: createUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String qualifiedName = null;
            if (requestBody != null) {
                qualifiedName = requestBody.getQualifiedName();
            }
            UserIdentityHandler handler = instanceHandler.getUserIdentityHandler(userId, serverName, "createUserIdentity");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createUserIdentity");
            handler.addUserIdentity(userId, qualifiedName, "createUserIdentity");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createUserIdentity", auditLog);
        }
        log.debug("Returning from method: createUserIdentity with response: " + response.toString());
        return response;
    }

    public VoidResponse addIdentityToProfile(String serverName, String userId, String profileGUID, UserIdentityRequestBody requestBody) {
        String methodName = "addIdentityToProfile";
        log.debug("Calling method: addIdentityToProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String qualifiedName = null;
            if (requestBody != null) {
                qualifiedName = requestBody.getQualifiedName();
            }
            UserIdentityHandler handler = instanceHandler.getUserIdentityHandler(userId, serverName, "addIdentityToProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addIdentityToProfile");
            handler.addIdentityToProfile(userId, qualifiedName, profileGUID, "addIdentityToProfile");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "addIdentityToProfile", auditLog);
        }
        log.debug("Returning from method: addIdentityToProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse removeIdentityFromProfile(String serverName, String userId, String profileGUID, UserIdentityRequestBody requestBody) {
        String methodName = "removeIdentityFromProfile";
        log.debug("Calling method: removeIdentityFromProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String qualifiedName = null;
            if (requestBody != null) {
                qualifiedName = requestBody.getQualifiedName();
            }
            UserIdentityHandler handler = instanceHandler.getUserIdentityHandler(userId, serverName, "removeIdentityFromProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeIdentityFromProfile");
            handler.removeIdentityFromProfile(userId, qualifiedName, profileGUID, "removeIdentityFromProfile");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeIdentityFromProfile", auditLog);
        }
        log.debug("Returning from method: removeIdentityFromProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse removeUserIdentity(String serverName, String userId, UserIdentityRequestBody requestBody) {
        String methodName = "removeUserIdentity";
        log.debug("Calling method: removeUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String qualifiedName = null;
            if (requestBody != null) {
                qualifiedName = requestBody.getQualifiedName();
            }
            UserIdentityHandler handler = instanceHandler.getUserIdentityHandler(userId, serverName, "removeUserIdentity");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeUserIdentity");
            handler.removeUserIdentity(userId, qualifiedName, "removeUserIdentity");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "removeUserIdentity", auditLog);
        }
        log.debug("Returning from method: removeUserIdentity with response: " + response.toString());
        return response;
    }
}

