/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.ContributionRecordHandler;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.PersonalProfileHandler;
import org.odpi.openmetadata.accessservices.communityprofile.handlers.UserIdentityHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class CommunityProfileServicesInstance
extends OMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.COMMUNITY_PROFILE_OMAS;
    private PersonalProfileHandler personalProfileHandler;
    private UserIdentityHandler userIdentityHandler;
    private ContributionRecordHandler contributionRecordHandler;

    public CommunityProfileServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, AuditLog auditLog, String localServerUserId, int maxPageSize, int karmaPointPlateau) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, auditLog, localServerUserId, maxPageSize);
        String methodName = "new ServiceInstance";
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(CommunityProfileErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.personalProfileHandler = new PersonalProfileHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.errorHandler);
        this.userIdentityHandler = new UserIdentityHandler(this.serviceName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.errorHandler);
        this.contributionRecordHandler = new ContributionRecordHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, karmaPointPlateau);
    }

    public PersonalProfileHandler getPersonalProfileHandler() {
        return this.personalProfileHandler;
    }

    public UserIdentityHandler getUserIdentityHandler() {
        return this.userIdentityHandler;
    }

    public ContributionRecordHandler getContributionRecordHandler() {
        return this.contributionRecordHandler;
    }
}

