/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.RatingElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.StarRating;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RatingConverter<B>
extends CommunityProfileOMASConverter<B> {
    public RatingConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RatingElement) {
                InstanceProperties instanceProperties;
                RatingElement bean = (RatingElement)returnBean;
                RatingProperties ratingProperties = new RatingProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    ratingProperties.setStarRating(this.removeStarRatingFromProperties(instanceProperties));
                    ratingProperties.setReview(this.removeReview(instanceProperties));
                    ratingProperties.setUser(entity.getCreatedBy());
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    ratingProperties.setPublic(this.getIsPublic(instanceProperties));
                }
                bean.setProperties(ratingProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    private StarRating removeStarRatingFromProperties(InstanceProperties properties) {
        StarRating starRating = this.getStarRatingFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("stars");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return starRating;
    }

    private StarRating getStarRatingFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        StarRating starRating = StarRating.NO_RECOMMENDATION;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    starRating = StarRating.NO_RECOMMENDATION;
                    break;
                }
                case 1: {
                    starRating = StarRating.ONE_STAR;
                    break;
                }
                case 2: {
                    starRating = StarRating.TWO_STARS;
                    break;
                }
                case 3: {
                    starRating = StarRating.THREE_STARS;
                    break;
                }
                case 4: {
                    starRating = StarRating.FOUR_STARS;
                    break;
                }
                case 99: {
                    starRating = StarRating.FIVE_STARS;
                }
            }
        }
        return starRating;
    }
}

