/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.outtopic;

import org.odpi.openmetadata.accessservices.communityprofile.connectors.outtopic.CommunityProfileOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileAuditCode;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ElementStub;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;

public class CommunityProfileOutTopicPublisher {
    private CommunityProfileOutTopicServerConnector outTopicServerConnector;
    private AuditLog outTopicAuditLog;
    private String outTopicName;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public CommunityProfileOutTopicPublisher(CommunityProfileOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog auditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = auditLog;
        this.outTopicName = outTopicName;
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    private void sendEvent(CommunityProfileOutboundEvent event, String principleElementGUID, String principleElementTypeName) {
        block2: {
            try {
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block2;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", CommunityProfileAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.getEventType().getEventTypeName(), principleElementGUID, principleElementTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void sentEntityEvent(CommunityProfileOutboundEventType eventType, String elementGUID, String elementTypeName, String classificationName, ElementStub elementStub) {
        CommunityProfileOutboundEvent event = new CommunityProfileOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(elementStub);
        event.setClassificationName(classificationName);
        if (this.outTopicAuditLog != null) {
            if (classificationName == null) {
                this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.OUTBOUND_ENTITY_EVENT.getMessageDefinition(new String[]{eventType.getEventTypeName(), elementGUID, elementTypeName}), elementStub.toString());
            } else {
                this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.OUTBOUND_CLASSIFICATION_EVENT.getMessageDefinition(new String[]{eventType.getEventTypeName(), elementGUID, elementTypeName, classificationName}), elementStub.toString());
            }
        }
        this.sendEvent(event, elementGUID, elementTypeName);
    }

    public void sentRelationshipEvent(CommunityProfileOutboundEventType eventType, String relationshipGUID, String relationshipTypeName, ElementStub relationshipElementStub, ElementStub endOneElementStub, ElementStub endTwoElementStub) {
        CommunityProfileOutboundEvent event = new CommunityProfileOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(relationshipElementStub);
        event.setEndOneElement(endOneElementStub);
        event.setEndTwoElement(endTwoElementStub);
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.OUTBOUND_RELATIONSHIP_EVENT.getMessageDefinition(new String[]{eventType.getEventTypeName(), relationshipGUID, relationshipTypeName, endOneElementStub.getType().getTypeName(), endOneElementStub.getGUID(), endTwoElementStub.getType().getTypeName(), endTwoElementStub.getGUID()}), relationshipElementStub.toString());
        }
        this.sendEvent(event, relationshipGUID, relationshipTypeName);
    }

    public void sendKarmaPointPlateauEvent(ElementStub profileElementStub, String contributingUserId, long pointsTotal, long plateau) {
        CommunityProfileOutboundEvent event = new CommunityProfileOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.KARMA_POINT_PLATEAU_EVENT);
        event.setPrincipleElement(profileElementStub);
        event.setUserId(contributingUserId);
        event.setPointsTotal(pointsTotal);
        event.setPlateau(plateau);
        this.sendEvent(event, profileElementStub.getGUID(), profileElementStub.getType().getTypeName());
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", CommunityProfileAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

