/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.NoteLogEntryElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.NoteLogEntryProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class NoteLogEntryConverter<B>
extends CommunityProfileOMASConverter<B> {
    public NoteLogEntryConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof NoteLogEntryElement) {
                NoteLogEntryElement bean = (NoteLogEntryElement)returnBean;
                NoteLogEntryProperties logEntryProperties = new NoteLogEntryProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    logEntryProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    logEntryProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    logEntryProperties.setTitle(this.removeTitle(instanceProperties));
                    logEntryProperties.setText(this.removeText(instanceProperties));
                    ArrayList<String> contributors = new ArrayList<String>();
                    contributors.add(entity.getCreatedBy());
                    if (entity.getUpdatedBy() != null && !entity.getUpdatedBy().equals(entity.getCreatedBy())) {
                        contributors.add(entity.getUpdatedBy());
                    }
                    if (entity.getMaintainedBy() != null) {
                        for (String maintainer : entity.getMaintainedBy()) {
                            if (maintainer == null || maintainer.equals(entity.getCreatedBy())) continue;
                            contributors.add(maintainer);
                        }
                    }
                    logEntryProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    logEntryProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(logEntryProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

