/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ProjectCollectionMember;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ProjectProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProjectCollectionMemberConverter<B>
extends CommunityProfileOMASConverter<B> {
    public ProjectCollectionMemberConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectCollectionMember) {
                InstanceProperties instanceProperties;
                ProjectCollectionMember bean = (ProjectCollectionMember)returnBean;
                ProjectProperties projectProperties = new ProjectProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    projectProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    projectProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    projectProperties.setName(this.removeName(instanceProperties));
                    projectProperties.setDescription(this.removeDescription(instanceProperties));
                    projectProperties.setStartDate(this.removeStartDate(instanceProperties));
                    projectProperties.setPlannedEndDate(this.removePlannedEndDate(instanceProperties));
                    projectProperties.setStatus(this.removeStatus(instanceProperties));
                    projectProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    projectProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    bean.setMembershipRationale(this.removeMembershipRationale(instanceProperties));
                    bean.setDateAddedToCollection(relationship.getCreateTime());
                }
                bean.setProperties(projectProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

