/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalReferenceConverter<B>
extends CommunityProfileOMASConverter<B> {
    public ExternalReferenceConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ExternalReferenceElement) {
                ExternalReferenceElement bean = (ExternalReferenceElement)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    ExternalReferenceProperties externalReferenceProperties = new ExternalReferenceProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    externalReferenceProperties.setResourceId(this.removeQualifiedName(instanceProperties));
                    externalReferenceProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    externalReferenceProperties.setResourceDisplayName(this.removeDisplayName(instanceProperties));
                    externalReferenceProperties.setResourceURL(this.removeURL(instanceProperties));
                    externalReferenceProperties.setResourceVersion(this.removeReferenceVersion(instanceProperties));
                    externalReferenceProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    externalReferenceProperties.setOwningOrganization(this.removeOrganization(instanceProperties));
                    externalReferenceProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    externalReferenceProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (relationship != null) {
                        instanceProperties = relationship.getProperties();
                        externalReferenceProperties.setLinkDescription(this.getDescription(instanceProperties));
                        externalReferenceProperties.setLinkId(this.getReferenceId(instanceProperties));
                    }
                    bean.setProperties(externalReferenceProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

