/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ContactMethodElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.ElementStub;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContributionRecord;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfileProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonalProfileConverter<B>
extends CommunityProfileOMASConverter<B> {
    public PersonalProfileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof PersonalProfileUniverse) {
                PersonalProfileUniverse bean = (PersonalProfileUniverse)returnBean;
                PersonalProfileProperties profileProperties = new PersonalProfileProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    profileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    profileProperties.setKnownName(this.removeName(instanceProperties));
                    profileProperties.setDescription(this.removeDescription(instanceProperties));
                    profileProperties.setFullName(this.removeFullName(instanceProperties));
                    profileProperties.setJobTitle(this.removeJobTitle(instanceProperties));
                    profileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    profileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    profileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProfileProperties(profileProperties);
                    if (supplementaryEntities != null) {
                        ArrayList<UserIdentityElement> userIdentities = new ArrayList<UserIdentityElement>();
                        ArrayList<ContactMethodElement> contactMethods = new ArrayList<ContactMethodElement>();
                        for (EntityDetail entity : supplementaryEntities) {
                            if (entity != null && entity.getType() != null) {
                                InstanceProperties entityProperties;
                                String entityTypeName = entity.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "UserIdentity")) {
                                    UserIdentityElement userBean = new UserIdentityElement();
                                    UserIdentityProperties userProperties = new UserIdentityProperties();
                                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    userProperties.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    userProperties.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    userProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    userProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    userBean.setProperties(userProperties);
                                    userIdentities.add(userBean);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "ContributionRecord")) {
                                    ContributionRecordElement contributionBean = new ContributionRecordElement();
                                    ContributionRecord contributionRecord = new ContributionRecord();
                                    contributionBean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    contributionRecord.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    contributionRecord.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    contributionRecord.setKarmaPoints(this.removeKarmaPoints(entityProperties));
                                    contributionRecord.setKarmaPointPlateau(this.karmaPointPlateau);
                                    contributionRecord.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    contributionRecord.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "ContactDetails")) continue;
                                ContactMethodElement contactMethodBean = new ContactMethodElement();
                                ContactMethodProperties contactMethodProperties = new ContactMethodProperties();
                                contactMethodBean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                                entityProperties = new InstanceProperties(entity.getProperties());
                                contactMethodProperties.setQualifiedName(this.removeQualifiedName(entityProperties));
                                contactMethodProperties.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                contactMethodProperties.setType(this.getContactMethodTypeFromProperties(entityProperties));
                                contactMethodProperties.setService(this.removeContactMethodService(entityProperties));
                                contactMethodProperties.setValue(this.removeContactMethodValue(entityProperties));
                                contactMethodProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                contactMethodProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                contactMethodBean.setProperties(contactMethodProperties);
                                contactMethods.add(contactMethodBean);
                                continue;
                            }
                            this.handleBadEntity(beanClass.getName(), entity, methodName);
                        }
                        if (!userIdentities.isEmpty()) {
                            bean.setUserIdentities(userIdentities);
                        }
                        if (!contactMethods.isEmpty()) {
                            bean.setContactMethods(contactMethods);
                        }
                    }
                    if (relationships != null) {
                        ArrayList<ElementStub> peers = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> roles = new ArrayList<ElementStub>();
                        for (Relationship relationship : relationships) {
                            if (relationship != null && relationship.getType() != null) {
                                ElementStub elementStub;
                                EntityProxy entityProxy;
                                String relationshipTypeName = relationship.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "Peer")) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    peers.add(elementStub);
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "PersonRoleAppointment")) continue;
                                entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                roles.add(elementStub);
                                continue;
                            }
                            this.handleBadRelationship(beanClass.getName(), relationship, methodName);
                        }
                        if (!peers.isEmpty()) {
                            bean.setPeers(peers);
                        }
                        if (!roles.isEmpty()) {
                            bean.setRoles(roles);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

