/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.MetadataSourceElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.MetadataSourceProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MetadataSourceResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class CommunityProfileRESTServices {
    private static CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CommunityProfileRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataSource(String serverName, String userId, MetadataSourceProperties requestBody) {
        String methodName = "createMetadataSource";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataSource");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataSource");
            if (requestBody != null) {
                SoftwareServerCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "createMetadataSource");
                response.setGUID(handler.createSoftwareServerCapability(userId, null, null, null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getVendorProperties(), null, null, "createMetadataSource"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataSource", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataSource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, String qualifiedName) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            SoftwareServerCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "getMetadataSourceGUID");
            response.setGUID(handler.getBeanGUIDByQualifiedName(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", qualifiedName, "qualifiedName", false, false, new Date(), "getMetadataSourceGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataSourceResponse getMetadataSource(String serverName, String userId, String metadataSourceGUID) {
        String methodName = "getMetadataSource";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSource");
        MetadataSourceResponse response = new MetadataSourceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSource");
            SoftwareServerCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "getMetadataSource");
            response.setElement((MetadataSourceElement)handler.getBeanFromRepository(userId, metadataSourceGUID, "metadataSourceGUID", "SoftwareServerCapability", false, false, new Date(), "getMetadataSource"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataSource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addUserProfileManagerClassification(String serverName, String userId, String metadataSourceGUID, NullRequestBody requestBody) {
        String methodName = "addUserProfileManagerClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addUserProfileManagerClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addUserProfileManagerClassification");
            SoftwareServerCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "addUserProfileManagerClassification");
            handler.addSoftwareServerCapabilityClassification(userId, null, null, metadataSourceGUID, "metadataSourceGUID", "UserProfileManager", null, null, "addUserProfileManagerClassification");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addUserProfileManagerClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addUserAccessDirectoryClassification(String serverName, String userId, String metadataSourceGUID, NullRequestBody requestBody) {
        String methodName = "addUserAccessDirectoryClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addUserAccessDirectoryClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addUserAccessDirectoryClassification");
            SoftwareServerCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "addUserAccessDirectoryClassification");
            handler.addSoftwareServerCapabilityClassification(userId, null, null, metadataSourceGUID, "metadataSourceGUID", "UserAccessDirectory", null, null, "addUserAccessDirectoryClassification");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addUserAccessDirectoryClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addMasterDataManagerClassification(String serverName, String userId, String metadataSourceGUID, NullRequestBody requestBody) {
        String methodName = "addMasterDataManagerClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addMasterDataManagerClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addMasterDataManagerClassification");
            SoftwareServerCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "addMasterDataManagerClassification");
            handler.addSoftwareServerCapabilityClassification(userId, null, null, metadataSourceGUID, "metadataSourceGUID", "MasterDataManager", null, null, "addMasterDataManagerClassification");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addMasterDataManagerClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

