/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIdentityRESTServices {
    private static CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(UserIdentityRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createUserIdentity(String serverName, String userId, UserIdentityRequestBody requestBody) {
        String methodName = "createUserIdentity";
        log.debug("Calling method: createUserIdentity");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "createUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createUserIdentity");
                String userIdentityGUID = handler.createUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, null, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), "createUserIdentity");
                response.setGUID(userIdentityGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createUserIdentity", auditLog);
        }
        log.debug("Returning from method: createUserIdentity with response: " + response.toString());
        return response;
    }

    public VoidResponse updateUserIdentity(String serverName, String userId, String userIdentityGUID, boolean isMergeUpdate, UserIdentityRequestBody requestBody) {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        log.debug("Calling method: updateUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "updateUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateUserIdentity");
                handler.updateUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), isMergeUpdate, "updateUserIdentity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateUserIdentity", auditLog);
        }
        log.debug("Returning from method: updateUserIdentity with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteUserIdentity(String serverName, String userId, String userIdentityGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        log.debug("Calling method: deleteUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "deleteUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteUserIdentity");
                handler.deleteUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", "deleteUserIdentity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteUserIdentity", auditLog);
        }
        log.debug("Returning from method: deleteUserIdentity with response: " + response.toString());
        return response;
    }

    public VoidResponse addIdentityToProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "addIdentityToProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        log.debug("Calling method: addIdentityToProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "addIdentityToProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addIdentityToProfile");
                handler.addIdentityToProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", "addIdentityToProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addIdentityToProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addIdentityToProfile", auditLog);
        }
        log.debug("Returning from method: addIdentityToProfile with response: " + response.toString());
        return response;
    }

    public VoidResponse removeIdentityFromProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "removeIdentityFromProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        log.debug("Calling method: removeIdentityFromProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "removeIdentityFromProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeIdentityFromProfile");
                handler.removeIdentifyFromProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", "removeIdentityFromProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeIdentityFromProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeIdentityFromProfile", auditLog);
        }
        log.debug("Returning from method: removeIdentityFromProfile with response: " + response.toString());
        return response;
    }

    public UserIdentityListResponse findUserIdentities(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        log.debug("Calling method: findUserIdentities");
        UserIdentityListResponse response = new UserIdentityListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "findUserIdentities");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findUserIdentities");
                List elements = handler.findBeans(userId, requestBody.getSearchString(), "searchString", "fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", null, startFrom, pageSize, null, "findUserIdentities");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findUserIdentities", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findUserIdentities", auditLog);
        }
        log.debug("Returning from method: findUserIdentities with response: " + response.toString());
        return response;
    }

    public UserIdentityListResponse getUserIdentitiesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getUserIdentitiesByName";
        String nameParameterName = "name";
        log.debug("Calling method: getUserIdentitiesByName");
        UserIdentityListResponse response = new UserIdentityListResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentitiesByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentitiesByName");
                List elements = handler.getUserIdentitiesByName(userId, requestBody.getName(), "name", startFrom, pageSize, "getUserIdentitiesByName");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getUserIdentitiesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentitiesByName", auditLog);
        }
        log.debug("Returning from method: getUserIdentitiesByName with response: " + response.toString());
        return response;
    }

    public UserIdentityResponse getUserIdentityByGUID(String serverName, String userId, String userIdentityGUID) {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        log.debug("Calling method: getUserIdentityByGUID");
        UserIdentityResponse response = new UserIdentityResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentityByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentityByGUID");
            UserIdentityElement element = (UserIdentityElement)handler.getUserIdentityByGUID(userId, userIdentityGUID, "userIdentityGUID", "getUserIdentityByGUID");
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentityByGUID", auditLog);
        }
        log.debug("Returning from method: getUserIdentityByGUID with response: " + response.toString());
        return response;
    }
}

