/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContributionRecord;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ContributionRecordConverter<B>
extends CommunityProfileOMASConverter<B> {
    public ContributionRecordConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, int karmaPointPlateau) {
        super(repositoryHelper, serviceName, serverName, karmaPointPlateau);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ContributionRecordElement) {
                ContributionRecordElement bean = (ContributionRecordElement)returnBean;
                ContributionRecord contributionRecord = new ContributionRecord();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties entityProperties = new InstanceProperties(entity.getProperties());
                    contributionRecord.setQualifiedName(this.removeQualifiedName(entityProperties));
                    contributionRecord.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                    contributionRecord.setKarmaPoints((long)this.removeKarmaPoints(entityProperties));
                    if (contributionRecord.getKarmaPoints() > 0L && this.karmaPointPlateau > 0L) {
                        contributionRecord.setKarmaPointPlateau(contributionRecord.getKarmaPoints() / this.karmaPointPlateau);
                    }
                    contributionRecord.setIsPublic(this.removeIsPublic(entityProperties));
                    contributionRecord.setEffectiveFrom(entityProperties.getEffectiveFromTime());
                    contributionRecord.setEffectiveTo(entityProperties.getEffectiveToTime());
                    contributionRecord.setTypeName(bean.getElementHeader().getType().getTypeName());
                    contributionRecord.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(contributionRecord);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

