/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ToDoElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDoProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ToDoStatus;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ToDoConverter<B>
extends CommunityProfileOMASConverter<B> {
    public ToDoConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ToDoElement) {
                ToDoElement bean = (ToDoElement)returnBean;
                ToDoProperties toDoProperties = new ToDoProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    toDoProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    toDoProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    toDoProperties.setName(this.removeName(instanceProperties));
                    toDoProperties.setDescription(this.removeDescription(instanceProperties));
                    toDoProperties.setCreationTime(this.removeCreationTime(instanceProperties));
                    toDoProperties.setPriority(this.removeIntPriority(instanceProperties));
                    toDoProperties.setDueTime(this.removeDueTime(instanceProperties));
                    toDoProperties.setCompletionTime(this.removeCompletionTime(instanceProperties));
                    toDoProperties.setStatus(this.getToDoStatusFromProperties(instanceProperties));
                    toDoProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    toDoProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    toDoProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    toDoProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(toDoProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }

    private ToDoStatus getToDoStatusFromProperties(InstanceProperties properties) {
        String methodName = "getToDoStatusFromProperties";
        ToDoStatus toDoStatus = ToDoStatus.ABANDONED;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "status", properties, "getToDoStatusFromProperties");
            switch (ordinal) {
                case 0: {
                    toDoStatus = ToDoStatus.OPEN;
                    break;
                }
                case 1: {
                    toDoStatus = ToDoStatus.IN_PROGRESS;
                    break;
                }
                case 2: {
                    toDoStatus = ToDoStatus.WAITING;
                    break;
                }
                case 3: {
                    toDoStatus = ToDoStatus.COMPLETE;
                    break;
                }
                case 99: {
                    toDoStatus = ToDoStatus.ABANDONED;
                }
            }
        }
        return toDoStatus;
    }
}

