/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ProfileIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActorProfileProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContactMethodProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ContributionRecord;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ProfileIdentityProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ActorProfileConverter<B>
extends CommunityProfileOMASConverter<B> {
    public ActorProfileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ActorProfileElement) {
                ActorProfileElement bean = (ActorProfileElement)returnBean;
                ActorProfileProperties profileProperties = new ActorProfileProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    profileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    profileProperties.setKnownName(this.removeName(instanceProperties));
                    profileProperties.setDescription(this.removeDescription(instanceProperties));
                    profileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    profileProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    profileProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    profileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    profileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProfileProperties(profileProperties);
                    HashMap<String, UserIdentityElement> userIdentities = new HashMap<String, UserIdentityElement>();
                    if (supplementaryEntities != null) {
                        ArrayList<ContactMethodElement> contactMethods = new ArrayList<ContactMethodElement>();
                        for (EntityDetail entity : supplementaryEntities) {
                            if (entity != null && entity.getType() != null) {
                                InstanceProperties entityProperties;
                                String entityTypeName = entity.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "UserIdentity")) {
                                    UserIdentityElement userBean = new UserIdentityElement();
                                    UserIdentityProperties userProperties = new UserIdentityProperties();
                                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    userProperties.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    userProperties.setDistinguishedName(this.removeDistinguishedName(instanceProperties));
                                    userProperties.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    userProperties.setEffectiveFrom(entityProperties.getEffectiveFromTime());
                                    userProperties.setEffectiveTo(entityProperties.getEffectiveToTime());
                                    userProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    userProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    userBean.setProperties(userProperties);
                                    userIdentities.put(entity.getGUID(), userBean);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "ContributionRecord")) {
                                    ContributionRecordElement contributionBean = new ContributionRecordElement();
                                    ContributionRecord contributionRecord = new ContributionRecord();
                                    contributionBean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    contributionRecord.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    contributionRecord.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    contributionRecord.setKarmaPoints((long)this.removeKarmaPoints(entityProperties));
                                    if (contributionRecord.getKarmaPoints() > 0L && this.karmaPointPlateau > 0L) {
                                        contributionRecord.setKarmaPointPlateau(contributionRecord.getKarmaPoints() / this.karmaPointPlateau);
                                    }
                                    contributionRecord.setIsPublic(this.removeIsPublic(entityProperties));
                                    contributionRecord.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    contributionRecord.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "ContactDetails")) continue;
                                ContactMethodElement contactMethodBean = new ContactMethodElement();
                                ContactMethodProperties contactMethodProperties = new ContactMethodProperties();
                                contactMethodBean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                                entityProperties = new InstanceProperties(entity.getProperties());
                                contactMethodProperties.setType(this.getContactMethodTypeFromProperties(entityProperties));
                                contactMethodProperties.setService(this.removeContactMethodService(entityProperties));
                                contactMethodProperties.setValue(this.removeContactMethodValue(entityProperties));
                                contactMethodProperties.setEffectiveFrom(entityProperties.getEffectiveFromTime());
                                contactMethodProperties.setEffectiveTo(entityProperties.getEffectiveToTime());
                                contactMethodProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                contactMethodProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                contactMethodBean.setProperties(contactMethodProperties);
                                contactMethods.add(contactMethodBean);
                                continue;
                            }
                            this.handleBadEntity(beanClass.getName(), entity, methodName);
                        }
                        if (!contactMethods.isEmpty()) {
                            bean.setContactMethods(contactMethods);
                        }
                    }
                    if (relationships != null) {
                        ElementStub superTeam = null;
                        ArrayList<ElementStub> subTeams = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> teamLeaders = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> teamMembers = new ArrayList<ElementStub>();
                        ArrayList<ProfileIdentityElement> profileIdentities = new ArrayList<ProfileIdentityElement>();
                        ArrayList<ElementStub> roles = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> linkedInfrastructure = new ArrayList<ElementStub>();
                        for (Relationship relationship : relationships) {
                            if (relationship != null && relationship.getType() != null) {
                                ElementStub elementStub;
                                EntityProxy entityProxy;
                                String relationshipTypeName = relationship.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "TeamMembership")) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    teamMembers.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "TeamLeadership")) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    teamLeaders.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "PersonRoleAppointment")) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    roles.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "ITInfrastructureProfile")) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    linkedInfrastructure.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "ProfileIdentity")) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    ProfileIdentityElement profileIdentityElement = new ProfileIdentityElement();
                                    ProfileIdentityProperties profileIdentityProperties = new ProfileIdentityProperties();
                                    InstanceProperties relationshipProperties = relationship.getProperties();
                                    profileIdentityProperties.setRoleTypeName(this.removeDescription(relationshipProperties));
                                    profileIdentityProperties.setRoleGUID(this.removeDescription(relationshipProperties));
                                    profileIdentityProperties.setDescription(this.removeDescription(relationshipProperties));
                                    profileIdentityElement.setProfileIdentity(profileIdentityProperties);
                                    profileIdentityElement.setProperties((UserIdentityElement)userIdentities.get(entityProxy.getGUID()));
                                    profileIdentities.add(profileIdentityElement);
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, "TeamStructure")) continue;
                                entityProxy = relationship.getEntityOneProxy();
                                if (primaryEntity.getGUID().equals(entityProxy.getGUID())) {
                                    elementStub = super.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName);
                                    subTeams.add(elementStub);
                                    continue;
                                }
                                superTeam = super.getElementStub(beanClass, entityProxy, methodName);
                                continue;
                            }
                            this.handleBadRelationship(beanClass.getName(), relationship, methodName);
                        }
                        if (!profileIdentities.isEmpty()) {
                            bean.setUserIdentities(profileIdentities);
                        }
                        bean.setSuperTeam(superTeam);
                        if (!subTeams.isEmpty()) {
                            bean.setSubTeams(subTeams);
                        }
                        if (!teamLeaders.isEmpty()) {
                            bean.setTeamLeaderRoles(teamLeaders);
                        }
                        if (!teamMembers.isEmpty()) {
                            bean.setTeamMemberRoles(teamMembers);
                        }
                        if (!roles.isEmpty()) {
                            bean.setPersonRoles(roles);
                        }
                        if (!linkedInfrastructure.isEmpty()) {
                            bean.setLinkedInfrastructure(linkedInfrastructure);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

