/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.SecurityGroupProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SecurityGroupConverter<B>
extends CommunityProfileOMASConverter<B> {
    public SecurityGroupConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SecurityGroupElement) {
                SecurityGroupElement bean = (SecurityGroupElement)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    String typeName = primaryEntity.getType().getTypeDefName();
                    SecurityGroupProperties securityGroupProperties = new SecurityGroupProperties();
                    securityGroupProperties.setDocumentIdentifier(this.removeQualifiedName(instanceProperties));
                    securityGroupProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    securityGroupProperties.setTitle(this.removeTitle(instanceProperties));
                    securityGroupProperties.setScope(this.removeScope(instanceProperties));
                    securityGroupProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    securityGroupProperties.setPriority(this.removePriority(instanceProperties));
                    securityGroupProperties.setOutcomes(this.removeOutcomes(instanceProperties));
                    securityGroupProperties.setResults(this.removeResults(instanceProperties));
                    securityGroupProperties.setDistinguishedName(this.removeDistinguishedName(instanceProperties));
                    securityGroupProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    securityGroupProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(securityGroupProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

