/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.CollectionElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionOrder;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CollectionProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CollectionConverter<B>
extends CommunityProfileOMASConverter<B> {
    public CollectionConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                CollectionProperties collectionProperties = new CollectionProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    collectionProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    collectionProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    collectionProperties.setName(this.removeName(instanceProperties));
                    collectionProperties.setDescription(this.removeDescription(instanceProperties));
                    collectionProperties.setCollectionOrdering(this.removeCollectionOrderFromProperties(instanceProperties));
                    collectionProperties.setOrderPropertyName(this.removeOrderPropertyName(instanceProperties));
                    collectionProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    collectionProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    collectionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    collectionProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(collectionProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, entity, methodName);
        if (returnBean instanceof CollectionElement) {
            CollectionElement bean = (CollectionElement)returnBean;
            bean.setRelatedElement(super.getRelatedElement(beanClass, entity, relationship, methodName));
        }
        return returnBean;
    }

    private CollectionOrder removeCollectionOrderFromProperties(InstanceProperties properties) {
        CollectionOrder collectionOrder = this.getCollectionOrderFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("orderBy");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return collectionOrder;
    }

    private CollectionOrder getCollectionOrderFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        CollectionOrder collectionOrder = CollectionOrder.NAME;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("orderPropertyName")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    collectionOrder = CollectionOrder.NAME;
                    break;
                }
                case 1: {
                    collectionOrder = CollectionOrder.OWNER;
                    break;
                }
                case 2: {
                    collectionOrder = CollectionOrder.DATE_ADDED;
                    break;
                }
                case 3: {
                    collectionOrder = CollectionOrder.DATE_UPDATED;
                    break;
                }
                case 4: {
                    collectionOrder = CollectionOrder.DATE_CREATED;
                    break;
                }
                case 99: {
                    collectionOrder = CollectionOrder.OTHER;
                }
            }
        }
        return collectionOrder;
    }
}

