/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.CommentElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.communityprofile.properties.CommentType;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentConverter<B>
extends CommunityProfileOMASConverter<B> {
    public CommentConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CommentElement) {
                InstanceProperties instanceProperties;
                CommentElement bean = (CommentElement)returnBean;
                CommentProperties commentProperties = new CommentProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    commentProperties.setUser(entity.getCreatedBy());
                    commentProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    commentProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    commentProperties.setCommentType(this.removeCommentTypeFromProperties(instanceProperties));
                    commentProperties.setCommentText(this.removeCommentText(instanceProperties));
                    commentProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    commentProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    commentProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    commentProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    commentProperties.setIsPublic(this.getIsPublic(instanceProperties));
                }
                bean.setProperties(commentProperties);
                bean.setRelatedElement(super.getRelatedElement(beanClass, entity, relationship, methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private CommentType removeCommentTypeFromProperties(InstanceProperties properties) {
        CommentType commentType = this.getCommentTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("commentType");
                instancePropertiesMap.remove("type");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return commentType;
    }

    private CommentType getCommentTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        CommentType commentType = CommentType.STANDARD_COMMENT;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    commentType = CommentType.STANDARD_COMMENT;
                    break;
                }
                case 1: {
                    commentType = CommentType.QUESTION;
                    break;
                }
                case 2: {
                    commentType = CommentType.ANSWER;
                    break;
                }
                case 3: {
                    commentType = CommentType.SUGGESTION;
                    break;
                }
                case 4: {
                    commentType = CommentType.USAGE_EXPERIENCE;
                    break;
                }
                case 99: {
                    commentType = CommentType.OTHER;
                }
            }
        }
        return commentType;
    }
}

