/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.omrstopic;

import java.util.Date;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileAuditCode;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.outtopic.CommunityProfileOutTopicPublisher;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileServicesInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityProfileOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(CommunityProfileOMRSTopicListener.class);
    private final CommunityProfileOutTopicPublisher publisher;
    private final OMRSRepositoryHelper repositoryHelper;
    private final int karmaPointIncrement;
    private final int karmaPointPlateauThreshold;
    private final String serverUserId;
    private final CommunityProfileOMASConverter<ElementStub> converter;
    private final CommunityProfileServicesInstance instance;

    public CommunityProfileOMRSTopicListener(int karmaPointIncrement, int karmaPointPlateauThreshold, CommunityProfileOutTopicPublisher publisher, String serverUserId, AuditLog auditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, CommunityProfileServicesInstance instance) {
        super(serviceName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.publisher = publisher;
        this.karmaPointIncrement = karmaPointIncrement;
        this.karmaPointPlateauThreshold = karmaPointPlateauThreshold;
        this.serverUserId = serverUserId;
        this.converter = new CommunityProfileOMASConverter(repositoryHelper, serviceName, serverName);
        this.instance = instance;
    }

    private void awardKarmaPoints(InstanceHeader contribution) {
        String methodName = "awardKarmaPoints";
        String userParameterName = "contribution.getUpdatedBy";
        if (this.karmaPointIncrement > 0 && contribution != null) {
            String contributingUserId = contribution.getUpdatedBy();
            if (contributingUserId == null) {
                contributingUserId = contribution.getCreatedBy();
            }
            try {
                ActorProfileElement personalProfile = (ActorProfileElement)this.instance.getActorProfileHandler().getActorProfileForUser(this.serverUserId, contributingUserId, "contribution.getUpdatedBy", "Person", false, false, new Date(), "awardKarmaPoints");
                if (personalProfile != null) {
                    String profileGUIDParameterName = "personalProfiles.get(0).getElementHeader().getGUID()";
                    ContributionRecordElement contributionRecord = personalProfile.getContributionRecord();
                    long currentPoints = 0L;
                    boolean isPublic = false;
                    if (contributionRecord != null && contributionRecord.getProperties() != null) {
                        currentPoints = contributionRecord.getProperties().getKarmaPoints();
                        isPublic = contributionRecord.getProperties().getIsPublic();
                    }
                    long newPoints = currentPoints + (long)this.karmaPointIncrement;
                    this.instance.getContributionRecordHandler().saveContributionRecord(this.serverUserId, personalProfile.getElementHeader().getGUID(), "personalProfiles.get(0).getElementHeader().getGUID()", personalProfile.getProfileProperties().getQualifiedName(), newPoints, false, null, null, null, true, false, false, new Date(), "awardKarmaPoints");
                    if (this.karmaPointPlateauThreshold != 0) {
                        long currentPlateau = currentPoints / (long)this.karmaPointPlateauThreshold;
                        long newPlateau = newPoints / (long)this.karmaPointPlateauThreshold;
                        log.debug("Karma points updated: " + contributingUserId);
                        if (newPlateau > currentPlateau) {
                            if (isPublic) {
                                this.auditLog.logMessage("awardKarmaPoints", CommunityProfileAuditCode.KARMA_PLATEAU_AWARD.getMessageDefinition(new String[]{contributingUserId, Long.toString(newPlateau), Long.toString(newPoints)}));
                            }
                            ElementStub elementStub = new ElementStub(personalProfile.getElementHeader());
                            elementStub.setUniqueName(personalProfile.getProfileProperties().getQualifiedName());
                            this.publisher.sendKarmaPointPlateauEvent(elementStub, contributingUserId, isPublic, newPlateau, newPoints);
                        }
                    }
                }
            }
            catch (Exception error) {
                this.auditLog.logException("awardKarmaPoints", CommunityProfileAuditCode.KARMA_POINT_EXCEPTION.getMessageDefinition(new String[]{contributingUserId, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processEntityEvent(CommunityProfileOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, String classificationName, String methodName) {
        this.awardKarmaPoints((InstanceHeader)entity);
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)entity, methodName);
        if (instanceTypeName != null) {
            try {
                ElementStub elementStub = this.converter.getElementStub(ElementStub.class, entity, methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "ActorProfile") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "UserIdentity") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "PersonRole") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "ContactDetails") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "Community")) {
                    this.publisher.sendEntityEvent(eventType, entity.getGUID(), instanceTypeName, classificationName, elementStub);
                }
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, CommunityProfileAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{entity.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processEntityEvent(CommunityProfileOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, String classificationName, String methodName) {
        this.awardKarmaPoints((InstanceHeader)entity);
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)entity, methodName);
        if (instanceTypeName != null) {
            try {
                ElementStub elementStub = this.converter.getElementStub(ElementStub.class, entity, methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "ActorProfile") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "UserIdentity") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "PersonRole") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "ContactDetails") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "Community")) {
                    this.publisher.sendEntityEvent(eventType, entity.getGUID(), instanceTypeName, classificationName, elementStub);
                }
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, CommunityProfileAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{entity.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processRelationshipEvent(CommunityProfileOutboundEventType eventType, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship, String methodName) {
        this.awardKarmaPoints((InstanceHeader)relationship);
        String instanceTypeName = this.getInstanceTypeName(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, (InstanceHeader)relationship, methodName);
        if (instanceTypeName != null) {
            try {
                ElementStub relationshipElementStub = this.converter.getElementStub(ElementStub.class, relationship, methodName);
                ElementStub endOneElementStub = this.converter.getElementStub(ElementStub.class, relationship.getEntityOneProxy(), methodName);
                ElementStub endTwoElementStub = this.converter.getElementStub(ElementStub.class, relationship.getEntityTwoProxy(), methodName);
                if (this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "PersonRoleAppointment") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "Peer") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "ProfileIdentity") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "TeamLeader") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "TeamMember") || this.repositoryHelper.isTypeOf(sourceName, instanceTypeName, "CommunityMembership")) {
                    this.publisher.sendRelationshipEvent(eventType, relationship.getGUID(), instanceTypeName, relationshipElementStub, endOneElementStub, endTwoElementStub);
                }
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, CommunityProfileAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{relationship.getGUID(), instanceTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.NEW_ELEMENT_CREATED;
        log.debug("Processing new Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processNewEntityEvent");
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.REFRESH_ELEMENT_EVENT;
        log.debug("Processing refresh Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processRefreshEntityEvent");
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_UPDATED;
        log.debug("Processing updated Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newEntity, null, "processUpdatedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_CLASSIFIED;
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, classification.getName(), "processClassifiedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_CLASSIFIED;
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, classification.getName(), "processClassifiedEntityEvent(proxy)");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_DECLASSIFIED;
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification.getName(), "processDeclassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent(proxy)";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_DECLASSIFIED;
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification.getName(), "processDeclassifiedEntityEvent(proxy)");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_RECLASSIFIED;
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification.getName(), "processReclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_RECLASSIFIED;
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification.getName(), "processReclassifiedEntityEvent");
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing deleted Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processDeletedEntityEvent");
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing delete-purge entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processDeletePurgedEntityEvent");
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_GUID_CHANGED;
        log.debug("Processing re-identified Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processReIdentifiedEntityEvent");
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_TYPE_CHANGED;
        log.debug("Processing re-typed Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processReTypedEntityEvent");
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_HOME_CHANGED;
        log.debug("Processing re-homed Entity event from: " + sourceName);
        this.processEntityEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, null, "processReHomedEntityEvent");
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.NEW_ELEMENT_CREATED;
        log.debug("Processing new relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processNewRelationshipEvent");
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_UPDATED;
        log.debug("Processing updated relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newRelationship, "processUpdatedRelationshipEvent");
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing deleted relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processDeletedRelationshipEvent");
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUpdatedRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_DELETED;
        log.debug("Processing delete-purge relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processUpdatedRelationshipEvent");
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_GUID_CHANGED;
        log.debug("Processing re-identified relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReIdentifiedRelationshipEvent");
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_TYPE_CHANGED;
        log.debug("Processing re-typed relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReTypedRelationshipEvent");
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        CommunityProfileOutboundEventType eventType = CommunityProfileOutboundEventType.ELEMENT_HOME_CHANGED;
        log.debug("Processing re-homed relationship event from: " + sourceName);
        this.processRelationshipEvent(eventType, sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship, "processReHomedRelationshipEvent");
    }
}

