/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.converters.CommunityProfileOMASConverter;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ContributionRecordElement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.PersonRoleAppointee;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.AppointmentProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ContactMethodRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.EffectiveDatesRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TeamPlayerRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContactDetailsHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContributionRecordHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class OrganizationRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OrganizationRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createActorProfile(String serverName, String userId, ActorProfileRequestBody requestBody) {
        String methodName = "createActorProfile";
        String guideParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createActorProfile");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "createActorProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createActorProfile");
                String profileGUID = handler.createActorProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getKnownName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "createActorProfile");
                if (requestBody.getContributionRecord() != null) {
                    ContributionRecordHandler<ContributionRecordElement> recordHandler = instanceHandler.getContributionRecordHandler(userId, serverName, "createActorProfile");
                    recordHandler.saveContributionRecord(userId, profileGUID, "profileGUID", requestBody.getProperties().getQualifiedName(), requestBody.getContributionRecord().getKarmaPoints(), requestBody.getContributionRecord().getIsPublic(), null, null, null, true, false, false, new Date(), "createActorProfile");
                }
                response.setGUID(profileGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createActorProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createActorProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateActorProfile(String serverName, String userId, String actorProfileGUID, boolean isMergeUpdate, ActorProfileRequestBody requestBody) {
        String methodName = "updateActorProfile";
        String guidParameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateActorProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "updateActorProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateActorProfile");
                handler.updateActorProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), actorProfileGUID, "actorProfileGUID", requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getKnownName(), requestBody.getProperties().getDescription(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateActorProfile");
                if (requestBody.getContributionRecord() != null) {
                    ContributionRecordHandler<ContributionRecordElement> recordHandler = instanceHandler.getContributionRecordHandler(userId, serverName, "updateActorProfile");
                    recordHandler.saveContributionRecord(userId, actorProfileGUID, "actorProfileGUID", requestBody.getProperties().getQualifiedName(), requestBody.getContributionRecord().getKarmaPoints(), requestBody.getContributionRecord().getIsPublic(), null, null, null, true, false, false, new Date(), "updateActorProfile");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateActorProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateActorProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteActorProfile(String serverName, String userId, String actorProfileGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteActorProfile";
        String guidParameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteActorProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "deleteActorProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteActorProfile");
                handler.removeActorProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), actorProfileGUID, "actorProfileGUID", false, false, new Date(), "deleteActorProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteActorProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteActorProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addContactMethod(String serverName, String userId, String actorProfileGUID, ContactMethodRequestBody requestBody) {
        String methodName = "addContactMethod";
        String guidParameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addContactMethod");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                ContactDetailsHandler<ContactMethodElement> handler = instanceHandler.getContactDetailsHandler(userId, serverName, "addContactMethod");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addContactMethod");
                int contactMethodTypeOrdinal = 0;
                if (requestBody.getProperties().getContactMethodType() != null) {
                    contactMethodTypeOrdinal = requestBody.getProperties().getContactMethodType().getOpenTypeOrdinal();
                }
                handler.createContactMethod(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), actorProfileGUID, "actorProfileGUID", requestBody.getProperties().getName(), requestBody.getProperties().getContactType(), contactMethodTypeOrdinal, requestBody.getProperties().getContactMethodService(), requestBody.getProperties().getContactMethodValue(), null, null, false, false, new Date(), "addContactMethod");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addContactMethod", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addContactMethod", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteContactMethod(String serverName, String userId, String contactMethodGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteContactMethod";
        String guidParameterName = "contactMethodGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteContactMethod");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            ContactDetailsHandler<ContactMethodElement> handler = instanceHandler.getContactDetailsHandler(userId, serverName, "deleteContactMethod");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteContactMethod");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), contactMethodGUID, "contactMethodGUID", "79296df8-645a-4ef7-a011-912d1cdcf75a", "ContactDetails", null, null, false, false, null, "deleteContactMethod");
            } else {
                handler.deleteBeanInRepository(userId, null, null, contactMethodGUID, "contactMethodGUID", "79296df8-645a-4ef7-a011-912d1cdcf75a", "ContactDetails", null, null, false, false, null, "deleteContactMethod");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteContactMethod", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkTeamsInHierarchy(String serverName, String userId, String superTeamProfileGUID, String subTeamProfileGUID, boolean delegationEscalationAuthority, EffectiveDatesRequestBody requestBody) {
        String methodName = "linkTeamsInHierarchy";
        String profileGUIDParameterName = "superTeamProfileGUID";
        String subTeamGUIDParameterName = "subTeamProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkTeamsInHierarchy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "linkTeamsInHierarchy");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "linkTeamsInHierarchy");
                handler.linkTeamHierarchy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), superTeamProfileGUID, "superTeamProfileGUID", subTeamProfileGUID, "subTeamProfileGUID", delegationEscalationAuthority, requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), false, false, new Date(), "linkTeamsInHierarchy");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkTeamsInHierarchy", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkTeamsInHierarchy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkTeamsInHierarchy(String serverName, String userId, String superTeamProfileGUID, String subTeamProfileGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "unlinkTeamsInHierarchy";
        String profileGUIDParameterName = "superTeamProfileGUID";
        String subTeamGUIDParameterName = "subTeamProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkTeamsInHierarchy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "unlinkTeamsInHierarchy");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkTeamsInHierarchy");
                handler.unlinkTeamHierarchy(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), superTeamProfileGUID, "superTeamProfileGUID", subTeamProfileGUID, "subTeamProfileGUID", false, false, new Date(), "unlinkTeamsInHierarchy");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unlinkTeamsInHierarchy", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkTeamsInHierarchy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileResponse getActorProfileByGUID(String serverName, String userId, String actorProfileGUID) {
        String methodName = "getActorProfileByGUID";
        String guidParameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfileByGUID");
        ActorProfileResponse response = new ActorProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfileByGUID");
            response.setElement((ActorProfileElement)handler.getActorProfileByGUID(userId, actorProfileGUID, "actorProfileGUID", "ActorProfile", false, false, new Date(), "getActorProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileResponse getActorProfileByUserId(String serverName, String userId, String actorProfileUserId) {
        String methodName = "getActorProfileByGUID";
        String nameParameterName = "actorProfileUserId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfileByGUID");
        ActorProfileResponse response = new ActorProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfileByGUID");
            response.setElement((ActorProfileElement)handler.getActorProfileForUser(userId, actorProfileUserId, "actorProfileUserId", "ActorProfile", false, false, new Date(), "getActorProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileListResponse getActorProfilesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getActorProfileByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfileByName");
        ActorProfileListResponse response = new ActorProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfileByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfileByName");
            response.setElements(handler.getActorProfilesByName(userId, requestBody.getName(), "name", "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", startFrom, pageSize, false, false, new Date(), "getActorProfileByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfileByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileListResponse getActorProfiles(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getActorProfiles";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfiles");
        ActorProfileListResponse response = new ActorProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfiles");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfiles");
            response.setElements(handler.getActorProfiles(userId, "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", startFrom, pageSize, false, false, new Date(), "getActorProfiles"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfiles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileListResponse getActorProfilesByLocation(String serverName, String userId, String locationGUID, int startFrom, int pageSize) {
        String methodName = "getActorProfilesByLocation";
        String guidParameterName = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfilesByLocation");
        ActorProfileListResponse response = new ActorProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfilesByLocation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfilesByLocation");
            response.setElements(handler.getActorProfilesByLocation(userId, locationGUID, "locationGUID", "ActorProfile", startFrom, pageSize, false, false, new Date(), "getActorProfilesByLocation"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfilesByLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileListResponse findActorProfiles(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findActorProfiles";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findActorProfiles");
        ActorProfileListResponse response = new ActorProfileListResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "findActorProfiles");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findActorProfiles");
            response.setElements(handler.findActorProfiles(userId, requestBody.getSearchString(), "searchString", "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", startFrom, pageSize, false, false, new Date(), "findActorProfiles"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findActorProfiles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createPersonRole(String serverName, String userId, PersonRoleRequestBody requestBody) {
        String methodName = "createPersonRole";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createPersonRole");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "createPersonRole");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createPersonRole");
                String profileGUID = handler.createPersonRole(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getRoleId(), requestBody.getProperties().getTitle(), requestBody.getProperties().getDescription(), requestBody.getProperties().getScope(), requestBody.getProperties().getHeadCount(), requestBody.getProperties().getHeadCountLimitSet(), requestBody.getProperties().getDomainIdentifier(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), new Date(), "createPersonRole");
                response.setGUID(profileGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createPersonRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createPersonRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updatePersonRole(String serverName, String userId, String personRoleGUID, boolean isMergeUpdate, PersonRoleRequestBody requestBody) {
        String methodName = "updatePersonRole";
        String guidParameterName = "personRoleGUID";
        String qualifiedNameParameterName = "properties.roleId";
        String nameParameterName = "properties.title";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updatePersonRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "updatePersonRole");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updatePersonRole");
                handler.updatePersonRole(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personRoleGUID, "personRoleGUID", requestBody.getProperties().getQualifiedName(), "properties.roleId", requestBody.getProperties().getRoleId(), requestBody.getProperties().getTitle(), "properties.title", requestBody.getProperties().getDescription(), requestBody.getProperties().getScope(), requestBody.getProperties().getHeadCount(), requestBody.getProperties().getHeadCountLimitSet(), requestBody.getProperties().getDomainIdentifier(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updatePersonRole");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updatePersonRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updatePersonRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deletePersonRole(String serverName, String userId, String personRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deletePersonRole";
        String guidParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deletePersonRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            ContactDetailsHandler<ContactMethodElement> handler = instanceHandler.getContactDetailsHandler(userId, serverName, "deletePersonRole");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deletePersonRole");
            if (requestBody != null) {
                handler.deleteBeanInRepository(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personRoleGUID, "personRoleGUID", "79296df8-645a-4ef7-a011-912d1cdcf75a", "ContactDetails", null, null, false, false, null, "deletePersonRole");
            } else {
                handler.deleteBeanInRepository(userId, null, null, personRoleGUID, "personRoleGUID", "79296df8-645a-4ef7-a011-912d1cdcf75a", "ContactDetails", null, null, false, false, null, "deletePersonRole");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deletePersonRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse linkPersonRoleToProfile(String serverName, String userId, String personRoleGUID, String personProfileGUID, AppointmentRequestBody requestBody) {
        String methodName = "linkPersonRoleToProfile";
        String profileGUIDParameterName = "personProfileGUID";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkPersonRoleToProfile");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "linkPersonRoleToProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "linkPersonRoleToProfile");
                String profileGUID = handler.appointPersonToRole(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), personProfileGUID, "personProfileGUID", personRoleGUID, "personRoleGUID", requestBody.getProperties().getIsPublic(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "linkPersonRoleToProfile");
                response.setGUID(profileGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkPersonRoleToProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkPersonRoleToProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRoleAppointeeListResponse getAppointees(String serverName, String userId, String personRoleGUID, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String methodName = "getAppointees";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAppointees");
        PersonRoleAppointeeListResponse response = new PersonRoleAppointeeListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> roleHandler = instanceHandler.getPersonRoleHandler(userId, serverName, "getAppointees");
            ActorProfileHandler<ActorProfileElement> profileHandler = instanceHandler.getActorProfileHandler(userId, serverName, "getAppointees");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAppointees");
            if (requestBody != null) {
                List appointmentRelationships = roleHandler.getAttachmentLinks(userId, personRoleGUID, "personRoleGUID", "PersonRole", "4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", null, "ActorProfile", 1, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getAppointees");
                if (appointmentRelationships != null) {
                    ArrayList<PersonRoleAppointee> appointees = new ArrayList<PersonRoleAppointee>();
                    OMRSRepositoryHelper repositoryHelper = roleHandler.getRepositoryHelper();
                    String serviceName = roleHandler.getServiceName();
                    CommunityProfileOMASConverter<PersonRoleAppointee> converter = new CommunityProfileOMASConverter<PersonRoleAppointee>(repositoryHelper, serviceName, serverName);
                    RepositoryErrorHandler errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
                    for (Relationship relationship : appointmentRelationships) {
                        if (relationship != null && relationship.getProperties() != null) {
                            if (requestBody.getEffectiveTime() == null) {
                                PersonRoleAppointee appointee = this.getAppointeeFromRelationship(userId, relationship, profileHandler, converter, repositoryHelper, serviceName, errorHandler, "getAppointees");
                                appointees.add(appointee);
                                continue;
                            }
                            InstanceProperties properties = relationship.getProperties();
                            Date effectiveTime = requestBody.getEffectiveTime();
                            if (properties.getEffectiveFromTime() != null && !properties.getEffectiveFromTime().before(effectiveTime) || properties.getEffectiveToTime() != null && !properties.getEffectiveToTime().after(effectiveTime)) continue;
                            PersonRoleAppointee appointee = this.getAppointeeFromRelationship(userId, relationship, profileHandler, converter, repositoryHelper, serviceName, errorHandler, "getAppointees");
                            appointees.add(appointee);
                            continue;
                        }
                        errorHandler.logBadRelationship("PersonRoleAppointment", relationship, "getAppointees");
                    }
                    if (!appointees.isEmpty()) {
                        response.setElements(appointees);
                    }
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAppointees", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAppointees", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private PersonRoleAppointee getAppointeeFromRelationship(String userId, Relationship relationship, ActorProfileHandler<ActorProfileElement> profileHandler, CommunityProfileOMASConverter<PersonRoleAppointee> converter, OMRSRepositoryHelper repositoryHelper, String serviceName, RepositoryErrorHandler errorHandler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String profileGUIDParameterName = "profileGUID";
        if (relationship != null && relationship.getProperties() != null && relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null) {
            PersonRoleAppointee appointee = new PersonRoleAppointee();
            InstanceProperties properties = relationship.getProperties();
            ElementHeader elementHeader = converter.getMetadataElementHeader(PersonRoleAppointee.class, (InstanceHeader)relationship, null, methodName);
            appointee.setElementHeader(elementHeader);
            AppointmentProperties appointmentProperties = new AppointmentProperties();
            appointmentProperties.setEffectiveFrom(properties.getEffectiveFromTime());
            appointmentProperties.setEffectiveTo(properties.getEffectiveToTime());
            appointmentProperties.setIsPublic(repositoryHelper.getBooleanProperty(serviceName, "isPublic", relationship.getProperties(), methodName));
            appointee.setProperties(appointmentProperties);
            ActorProfileElement profile = (ActorProfileElement)profileHandler.getActorProfileByGUID(userId, relationship.getEntityOneProxy().getGUID(), "profileGUID", "ActorProfile", false, false, new Date(), methodName);
            appointee.setProfile(profile);
            return appointee;
        }
        errorHandler.logBadRelationship("PersonRoleAppointment", relationship, methodName);
        return null;
    }

    public VoidResponse updateAppointment(String serverName, String userId, String appointmentGUID, boolean isMergeUpdate, AppointmentRequestBody requestBody) {
        String methodName = "updatePersonRole";
        String guidParameterName = "appointmentGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updatePersonRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "updatePersonRole");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updatePersonRole");
                handler.updateAppointment(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), appointmentGUID, "appointmentGUID", requestBody.getProperties().getIsPublic(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updatePersonRole");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updatePersonRole", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updatePersonRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkPersonRoleFromProfile(String serverName, String userId, String appointmentGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "unlinkPersonRoleFromProfile";
        String appointmentGUIDParameterName = "appointmentGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkPersonRoleFromProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "unlinkPersonRoleFromProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkPersonRoleFromProfile");
            if (requestBody != null) {
                handler.relievePersonFromRole(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, null, null, null, appointmentGUID, "appointmentGUID", new Date(), new Date(), "unlinkPersonRoleFromProfile");
            } else {
                handler.relievePersonFromRole(userId, null, null, null, null, null, null, appointmentGUID, "appointmentGUID", new Date(), new Date(), "unlinkPersonRoleFromProfile");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkPersonRoleFromProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkTeamPlayer(String serverName, String userId, String teamRoleGUID, String teamProfileGUID, TeamPlayerRequestBody requestBody) {
        String methodName = "linkTeamPlayer";
        String teamRoleGUIDParameterName = "teamRoleGUID";
        String teamProfileGUIDParameterName = "teamProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkTeamPlayer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "linkTeamPlayer");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "linkTeamPlayer");
                if (requestBody.getIsLeadershipRole()) {
                    handler.addTeamLeader(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), teamRoleGUID, "teamRoleGUID", teamProfileGUID, "teamProfileGUID", requestBody.getPosition(), null, null, false, false, new Date(), "linkTeamPlayer");
                } else {
                    handler.addTeamLeader(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), teamRoleGUID, "teamRoleGUID", teamProfileGUID, "teamProfileGUID", requestBody.getPosition(), null, null, false, false, new Date(), "linkTeamPlayer");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkTeamPlayer", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkTeamPlayer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkTeamPlayer(String serverName, String userId, String teamRoleGUID, String teamProfileGUID, TeamPlayerRequestBody requestBody) {
        String methodName = "unlinkTeamPlayer";
        String teamRoleGUIDParameterName = "teamRoleGUID";
        String teamProfileGUIDParameterName = "teamProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkTeamPlayer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "unlinkTeamPlayer");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkTeamPlayer");
                if (requestBody.getIsLeadershipRole()) {
                    handler.removeTeamLeader(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), teamRoleGUID, "teamRoleGUID", teamProfileGUID, "teamProfileGUID", false, false, new Date(), "unlinkTeamPlayer");
                } else {
                    handler.removeTeamMember(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), teamRoleGUID, "teamRoleGUID", teamProfileGUID, "teamProfileGUID", false, false, new Date(), "unlinkTeamPlayer");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "unlinkTeamPlayer", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unlinkTeamPlayer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRoleResponse getPersonRoleByGUID(String serverName, String userId, String personRoleGUID) {
        String methodName = "getPersonRoleByGUID";
        String guidParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonRoleByGUID");
        PersonRoleResponse response = new PersonRoleResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getPersonRoleByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonRoleByGUID");
            response.setElement((PersonRoleElement)handler.getPersonRoleByGUID(userId, personRoleGUID, "personRoleGUID", false, false, new Date(), "getPersonRoleByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonRoleByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRoleListResponse getPersonRoleByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getPersonRoleByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonRoleByName");
        PersonRoleListResponse response = new PersonRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getPersonRoleByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonRoleByName");
            response.setElements(handler.getPersonRolesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getPersonRoleByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonRoleByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRoleListResponse getLeadershipRolesForTeam(String serverName, String userId, String teamGUID, int startFrom, int pageSize) {
        String methodName = "getLeadershipRolesForTeam";
        String guidParameterName = "teamGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLeadershipRolesForTeam");
        PersonRoleListResponse response = new PersonRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getLeadershipRolesForTeam");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLeadershipRolesForTeam");
            response.setElements(handler.getTeamLeaderRoles(userId, teamGUID, "teamGUID", startFrom, pageSize, false, false, new Date(), "getLeadershipRolesForTeam"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLeadershipRolesForTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRoleListResponse getMembershipRolesForTeam(String serverName, String userId, String teamGUID, int startFrom, int pageSize) {
        String methodName = "getMembershipRolesForTeam";
        String guidParameterName = "teamGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMembershipRolesForTeam");
        PersonRoleListResponse response = new PersonRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getMembershipRolesForTeam");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMembershipRolesForTeam");
            response.setElements(handler.getTeamMemberRoles(userId, teamGUID, "teamGUID", startFrom, pageSize, false, false, new Date(), "getMembershipRolesForTeam"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMembershipRolesForTeam", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRoleListResponse findPersonRoles(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findPersonRoles";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findPersonRoles");
        PersonRoleListResponse response = new PersonRoleListResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "findPersonRoles");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findPersonRoles");
            response.setElements(handler.findPersonRoles(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findPersonRoles"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findPersonRoles", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

