/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentityResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ProfileIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class UserIdentityRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(UserIdentityRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createUserIdentity(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createUserIdentity";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createUserIdentity");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof UserIdentityProperties) {
                    UserIdentityProperties userIdentityProperties = (UserIdentityProperties)referenceableProperties;
                    UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "createUserIdentity");
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "createUserIdentity");
                    String userIdentityGUID = handler.createUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getParentGUID(), "profileGUID", userIdentityProperties.getQualifiedName(), userIdentityProperties.getUserId(), userIdentityProperties.getDistinguishedName(), userIdentityProperties.getAdditionalProperties(), userIdentityProperties.getTypeName(), userIdentityProperties.getExtendedProperties(), false, false, new Date(), "createUserIdentity");
                    response.setGUID(userIdentityGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(UserIdentityProperties.class.getName(), "createUserIdentity");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateUserIdentity(String serverName, String userId, String userIdentityGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof UserIdentityProperties) {
                    UserIdentityProperties userIdentityProperties = (UserIdentityProperties)referenceableProperties;
                    UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "updateUserIdentity");
                    auditLog = instanceHandler.getAuditLog(userId, serverName, "updateUserIdentity");
                    handler.updateUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", userIdentityProperties.getQualifiedName(), userIdentityProperties.getUserId(), userIdentityProperties.getDistinguishedName(), userIdentityProperties.getAdditionalProperties(), userIdentityProperties.getTypeName(), userIdentityProperties.getExtendedProperties(), isMergeUpdate, userIdentityProperties.getEffectiveFrom(), userIdentityProperties.getEffectiveTo(), false, false, new Date(), "updateUserIdentity");
                } else {
                    this.restExceptionHandler.handleNoRequestBody(userId, "updateUserIdentity", serverName);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteUserIdentity(String serverName, String userId, String userIdentityGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "deleteUserIdentity");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteUserIdentity");
            if (requestBody != null) {
                handler.deleteUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", false, false, new Date(), "deleteUserIdentity");
            } else {
                handler.deleteUserIdentity(userId, null, null, userIdentityGUID, "userIdentityGUID", false, false, new Date(), "deleteUserIdentity");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addIdentityToProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, RelationshipRequestBody requestBody) {
        String methodName = "addIdentityToProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addIdentityToProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "addIdentityToProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addIdentityToProfile");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ProfileIdentityProperties) {
                    ProfileIdentityProperties properties = (ProfileIdentityProperties)relationshipProperties;
                    handler.addIdentityToProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", properties.getRoleTypeName(), properties.getRoleGUID(), properties.getDescription(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "addIdentityToProfile");
                } else if (requestBody.getProperties() == null) {
                    handler.addIdentityToProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", null, null, null, null, null, false, false, new Date(), "addIdentityToProfile");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ProfileIdentityProperties.class.getName(), "addIdentityToProfile");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addIdentityToProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addIdentityToProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIdentityProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, boolean isMergeUpdate, RelationshipRequestBody requestBody) {
        String methodName = "updateIdentityProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIdentityProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "updateIdentityProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIdentityProfile");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ProfileIdentityProperties) {
                    ProfileIdentityProperties properties = (ProfileIdentityProperties)relationshipProperties;
                    handler.updateIdentityProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), profileGUID, "profileGUID", userIdentityGUID, "userIdentityGUID", properties.getRoleTypeName(), properties.getRoleGUID(), properties.getDescription(), requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateIdentityProfile");
                } else if (requestBody.getProperties() == null) {
                    handler.updateIdentityProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), profileGUID, "profileGUID", userIdentityGUID, "userIdentityGUID", null, null, null, null, null, isMergeUpdate, false, false, new Date(), "updateIdentityProfile");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(ProfileIdentityProperties.class.getName(), "updateIdentityProfile");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIdentityProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIdentityProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeIdentityFromProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeIdentityFromProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeIdentityFromProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "removeIdentityFromProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeIdentityFromProfile");
            if (requestBody != null) {
                handler.removeIdentifyFromProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", false, false, new Date(), "removeIdentityFromProfile");
            } else {
                handler.removeIdentifyFromProfile(userId, null, null, userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", false, false, new Date(), "removeIdentityFromProfile");
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeIdentityFromProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentitiesResponse findUserIdentities(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findUserIdentities");
        UserIdentitiesResponse response = new UserIdentitiesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "findUserIdentities");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findUserIdentities");
                List elements = handler.findBeans(userId, requestBody.getSearchString(), "searchString", OpenMetadataType.USER_IDENTITY.typeGUID, OpenMetadataType.USER_IDENTITY.typeName, null, startFrom, pageSize, false, false, new Date(), "findUserIdentities");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findUserIdentities", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findUserIdentities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentitiesResponse getUserIdentitiesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getUserIdentitiesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getUserIdentitiesByName");
        UserIdentitiesResponse response = new UserIdentitiesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentitiesByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentitiesByName");
                List elements = handler.getUserIdentitiesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getUserIdentitiesByName");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getUserIdentitiesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentitiesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentityResponse getUserIdentityByGUID(String serverName, String userId, String userIdentityGUID) {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getUserIdentityByGUID");
        UserIdentityResponse response = new UserIdentityResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentityByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentityByGUID");
            UserIdentityElement element = (UserIdentityElement)handler.getUserIdentityByGUID(userId, userIdentityGUID, "userIdentityGUID", false, false, new Date(), "getUserIdentityByGUID");
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentityByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

