/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.outtopic;

import org.odpi.openmetadata.accessservices.communityprofile.connectors.outtopic.CommunityProfileOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEventType;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;

public class CommunityProfileOutTopicPublisher {
    private final CommunityProfileOutTopicServerConnector outTopicServerConnector;
    private final AuditLog outTopicAuditLog;
    private final String outTopicName;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public CommunityProfileOutTopicPublisher(CommunityProfileOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog auditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = auditLog;
        this.outTopicName = outTopicName;
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    private void sendEvent(CommunityProfileOutboundEvent event, String principleElementGUID, String principleElementTypeName) {
        block2: {
            try {
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block2;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", CommunityProfileAuditCode.OUTBOUND_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.getEventType().getEventTypeName(), principleElementGUID, principleElementTypeName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void sendEntityEvent(CommunityProfileOutboundEventType eventType, String elementGUID, String elementTypeName, String classificationName, ElementStub elementStub) {
        CommunityProfileOutboundEvent event = new CommunityProfileOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(elementStub);
        event.setClassificationName(classificationName);
        this.sendEvent(event, elementGUID, elementTypeName);
    }

    public void sendRelationshipEvent(CommunityProfileOutboundEventType eventType, String relationshipGUID, String relationshipTypeName, ElementStub relationshipElementStub, ElementStub endOneElementStub, ElementStub endTwoElementStub) {
        CommunityProfileOutboundEvent event = new CommunityProfileOutboundEvent();
        event.setEventType(eventType);
        event.setPrincipleElement(relationshipElementStub);
        event.setEndOneElement(endOneElementStub);
        event.setEndTwoElement(endTwoElementStub);
        this.sendEvent(event, relationshipGUID, relationshipTypeName);
    }

    public void sendKarmaPointPlateauEvent(ElementStub profileElementStub, String contributingUserId, boolean isPublic, long pointsTotal, long plateau) {
        CommunityProfileOutboundEvent event = new CommunityProfileOutboundEvent();
        event.setEventType(CommunityProfileOutboundEventType.KARMA_POINT_PLATEAU_EVENT);
        event.setPrincipleElement(profileElementStub);
        event.setUserId(contributingUserId);
        event.setIsPublic(isPublic);
        event.setPointsTotal(pointsTotal);
        event.setPlateau(plateau);
        this.sendEvent(event, profileElementStub.getGUID(), profileElementStub.getType().getTypeName());
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", CommunityProfileAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", CommunityProfileAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

