/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionMembersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CollectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.CollectionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionFolderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.LoggerFactory;

public class CollectionRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CollectionRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createCollection(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createCollection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createCollection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCollection");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "createCollection");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof CollectionProperties) {
                    CollectionProperties properties = (CollectionProperties)referenceableProperties;
                    String collectionGUID = handler.createCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getName(), properties.getDescription(), properties.getCollectionType(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), null, properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createCollection");
                    if (collectionGUID != null) {
                        handler.setVendorProperties(userId, collectionGUID, properties.getVendorProperties(), false, false, new Date(), "createCollection");
                    }
                    response.setGUID(collectionGUID);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CollectionProperties.class.getName(), "createCollection");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createFolderCollection(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createFolderCollection";
        String collectionGUIDParameterName = "collectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createFolderCollection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createFolderCollection");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "createFolderCollection");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof CollectionFolderProperties) {
                    CollectionFolderProperties properties = (CollectionFolderProperties)referenceableProperties;
                    String collectionGUID = handler.createCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getName(), properties.getDescription(), properties.getCollectionType(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), null, properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createFolderCollection");
                    if (collectionGUID != null) {
                        handler.addFolderClassificationToCollection(userId, collectionGUID, "collectionGUID", properties.getCollectionOrder().getOrdinal(), properties.getOrderByPropertyName(), false, false, false, null, "createFolderCollection");
                        handler.setVendorProperties(userId, collectionGUID, properties.getVendorProperties(), false, false, null, "createFolderCollection");
                    }
                    response.setGUID(collectionGUID);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CollectionProperties.class.getName(), "createFolderCollection");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createFolderCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createFolderCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCollection(String serverName, String userId, String collectionGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateCollection";
        String collectionGUIDParameterName = "collectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCollection");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "updateCollection");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof CollectionProperties) {
                    CollectionProperties properties = (CollectionProperties)referenceableProperties;
                    handler.updateCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), collectionGUID, "collectionGUID", properties.getQualifiedName(), properties.getName(), properties.getDescription(), properties.getCollectionType(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateCollection");
                    if (!isMergeUpdate || properties.getVendorProperties() != null) {
                        handler.setVendorProperties(userId, collectionGUID, properties.getVendorProperties(), false, false, new Date(), "updateCollection");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CollectionProperties.class.getName(), "updateCollection");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCollectionMembership(String serverName, String userId, String collectionGUID, String collectionRoleGUID, boolean isMergeUpdate, RelationshipRequestBody requestBody) {
        String methodName = "updateCollectionMembership";
        String collectionGUIDParameterName = "collectionGUID";
        String collectionRoleGUIDParameterName = "collectionRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCollectionMembership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCollectionMembership");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "updateCollectionMembership");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof CollectionMembershipProperties) {
                    CollectionMembershipProperties properties = (CollectionMembershipProperties)relationshipProperties;
                    int ordinal = 0;
                    if (properties.getStatus() != null) {
                        ordinal = properties.getStatus().getOrdinal();
                    }
                    handler.updateCollectionMembership(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), collectionGUID, "collectionGUID", collectionRoleGUID, "collectionRoleGUID", properties.getMembershipRationale(), properties.getExpression(), ordinal, properties.getUserDefinedStatus(), properties.getConfidence(), properties.getCreatedBy(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getSource(), properties.getNotes(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateCollectionMembership");
                } else if (requestBody.getProperties() == null) {
                    handler.addMemberToCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), collectionGUID, "collectionGUID", collectionRoleGUID, "collectionRoleGUID", null, null, null, false, false, new Date(), "updateCollectionMembership");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CollectionMembershipProperties.class.getName(), "updateCollectionMembership");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateCollectionMembership", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCollectionMembership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeFromCollection(String serverName, String userId, String collectionGUID, String collectionRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeFromCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String collectionRoleGUIDParameterName = "collectionRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeFromCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFromCollection");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "removeFromCollection");
            if (requestBody != null) {
                handler.removeMemberFromCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), collectionGUID, "collectionGUID", collectionRoleGUID, "collectionRoleGUID", false, false, new Date(), "removeFromCollection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeFromCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFromCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCollection(String serverName, String userId, String collectionGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeCollection";
        String collectionGUIDParameterName = "collectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeCollection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeCollection");
                CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "removeCollection");
                handler.removeCollection(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), collectionGUID, "collectionGUID", false, false, new Date(), "removeCollection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeCollection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeCollection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse findCollections(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findCollections";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findCollections");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findCollections");
            if (requestBody != null) {
                CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "findCollections");
                List collections = handler.findCollections(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findCollections");
                response.setElements(this.setUpVendorProperties(userId, collections, handler, "findCollections"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findCollections", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findCollections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse getCollectionsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getCollectionsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCollectionsByName");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollectionsByName");
            if (requestBody != null) {
                CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "getCollectionsByName");
                List collections = handler.getCollectionsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getCollectionsByName");
                response.setElements(this.setUpVendorProperties(userId, collections, handler, "getCollectionsByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getCollectionsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionMembersResponse getCollectionMembers(String serverName, String userId, String collectionGUID, int startFrom, int pageSize) {
        String methodName = "getCollectionMembers";
        String guidParameterName = "collectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCollectionMembers");
        CollectionMembersResponse response = new CollectionMembersResponse();
        AuditLog auditLog = null;
        try {
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "getCollectionMembers");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollectionMembers");
            List list = handler.getAttachmentLinks(userId, collectionGUID, "collectionGUID", OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, null, OpenMetadataType.REFERENCEABLE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getCollectionMembers");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollectionMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionsResponse getCollections(String serverName, String userId, String parentGUID, int startFrom, int pageSize) {
        String methodName = "getCollections";
        String parentGUIDParameterName = "parentGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCollections");
        CollectionsResponse response = new CollectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollections");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "getCollections");
            List collections = handler.getAttachedElements(userId, parentGUID, "parentGUID", OpenMetadataType.REFERENCEABLE.typeName, null, null, OpenMetadataType.COLLECTION.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, new Date(), "getCollections");
            response.setElements(this.setUpVendorProperties(userId, collections, handler, "getCollections"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CollectionResponse getCollectionByGUID(String serverName, String userId, String guid) {
        String methodName = "getCollectionByGUID";
        String guidParameterName = "collectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCollectionByGUID");
        CollectionResponse response = new CollectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCollectionByGUID");
            CollectionHandler<CollectionElement> handler = instanceHandler.getCollectionHandler(userId, serverName, "getCollectionByGUID");
            CollectionElement collection = (CollectionElement)handler.getCollectionByGUID(userId, guid, "collectionGUID", false, false, new Date(), "getCollectionByGUID");
            response.setElement(this.setUpVendorProperties(userId, collection, handler, "getCollectionByGUID"));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCollectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<CollectionElement> setUpVendorProperties(String userId, List<CollectionElement> retrievedResults, CollectionHandler<CollectionElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (CollectionElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private CollectionElement setUpVendorProperties(String userId, CollectionElement element, CollectionHandler<CollectionElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            CollectionProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

