/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.accessservices.communityprofile.server.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityGroupResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityGroupsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityGroupProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.slf4j.LoggerFactory;

public class SecurityGroupRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SecurityGroupRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createSecurityGroup(String serverName, String userId, SecurityGroupProperties requestBody) {
        String methodName = "createSecurityGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSecurityGroup");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "createSecurityGroup");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createSecurityGroup");
                String groupGUID = handler.createGovernanceDefinition(userId, requestBody.getDocumentIdentifier(), requestBody.getTitle(), requestBody.getSummary(), requestBody.getDescription(), requestBody.getScope(), requestBody.getDomainIdentifier(), requestBody.getPriority(), requestBody.getImplications(), requestBody.getOutcomes(), requestBody.getResults(), null, null, null, null, null, requestBody.getDistinguishedName(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, new Date(), "createSecurityGroup");
                response.setGUID(groupGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSecurityGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSecurityGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSecurityGroup(String serverName, String userId, String securityGroupGUID, boolean isMergeUpdate, SecurityGroupProperties requestBody) {
        String methodName = "updateSecurityGroup";
        String guidParameterName = "securityGroupGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSecurityGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "updateSecurityGroup");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSecurityGroup");
                handler.updateGovernanceDefinition(userId, securityGroupGUID, "securityGroupGUID", requestBody.getDocumentIdentifier(), requestBody.getTitle(), requestBody.getSummary(), requestBody.getDescription(), requestBody.getScope(), requestBody.getDomainIdentifier(), requestBody.getPriority(), requestBody.getImplications(), requestBody.getOutcomes(), requestBody.getResults(), null, null, null, null, null, requestBody.getDistinguishedName(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateSecurityGroup");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSecurityGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateSecurityGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteSecurityGroup(String serverName, String userId, String securityGroupGUID, NullRequestBody requestBody) {
        String methodName = "deleteSecurityGroup";
        String guidParameterName = "securityGroupGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteSecurityGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "deleteSecurityGroup");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteSecurityGroup");
                handler.removeGovernanceDefinition(userId, securityGroupGUID, "securityGroupGUID", false, false, new Date(), "deleteSecurityGroup");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteSecurityGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteSecurityGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityGroupsResponse getSecurityGroupsForDistinguishedName(String serverName, String userId, String distinguishedName, int startFrom, int pageSize) {
        String methodName = "getSecurityGroupsForDistinguishedName";
        String distinguishedNameParameterName = "distinguishedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityGroupsForDistinguishedName");
        SecurityGroupsResponse response = new SecurityGroupsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "getSecurityGroupsForDistinguishedName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityGroupsForDistinguishedName");
            response.setElements(handler.getGovernanceDefinitionsByStringParameter(userId, "042d9b5c-677e-477b-811f-1c39bf716759", "SecurityGroup", distinguishedName, "distinguishedName", OpenMetadataProperty.DISTINGUISHED_NAME.name, startFrom, pageSize, false, false, new Date(), "getSecurityGroupsForDistinguishedName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSecurityGroupsForDistinguishedName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getElementsGovernedBySecurityGroup(String serverName, String userId, String securityGroupGUID, int startFrom, int pageSize) {
        String methodName = "getElementsGovernedBySecurityGroup";
        String guidParameterName = "securityGroupGUID";
        return null;
    }

    public SecurityGroupsResponse findSecurityGroups(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSecurityGroups";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSecurityGroups");
        SecurityGroupsResponse response = new SecurityGroupsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "findSecurityGroups");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findSecurityGroups");
                response.setElements(handler.findGovernanceDefinitions(userId, "SecurityGroup", requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findSecurityGroups"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findSecurityGroups", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findSecurityGroups", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityGroupResponse getSecurityGroupByGUID(String serverName, String userId, String securityGroupGUID) {
        String methodName = "getSecurityGroupByGUID";
        String guidParameterName = "securityGroupGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityGroupByGUID");
        SecurityGroupResponse response = new SecurityGroupResponse();
        AuditLog auditLog = null;
        try {
            GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "getSecurityGroupByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityGroupByGUID");
            response.setElement((SecurityGroupElement)handler.getGovernanceDefinitionByGUID(userId, securityGroupGUID, "securityGroupGUID", false, false, new Date(), "getSecurityGroupByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSecurityGroupByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

