/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataSourceElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.MetadataSourceProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class CommunityProfileRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CommunityProfileRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public RegisteredOMAGServiceResponse getServiceDescription(String serverName, String userId) {
        String methodName = "getServiceDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServiceDescription");
        RegisteredOMAGServiceResponse response = new RegisteredOMAGServiceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServiceDescription");
            response.setService(instanceHandler.getRegisteredOMAGService(userId, serverName, AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceCode(), "getServiceDescription"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServiceDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataSource(String serverName, String userId, MetadataSourceProperties requestBody) {
        String methodName = "createMetadataSource";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataSource");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataSource");
            if (requestBody != null) {
                SoftwareCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "createMetadataSource");
                response.setGUID(handler.createSoftwareCapability(userId, null, null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), null, requestBody.getVendorProperties(), null, null, false, false, new Date(), "createMetadataSource"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataSource", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createMetadataSource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, String qualifiedName) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            SoftwareCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "getMetadataSourceGUID");
            response.setGUID(handler.getBeanGUIDByQualifiedName(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, qualifiedName, "qualifiedName", false, false, new Date(), "getMetadataSourceGUID"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataSourceResponse getMetadataSource(String serverName, String userId, String metadataSourceGUID) {
        String methodName = "getMetadataSource";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSource");
        MetadataSourceResponse response = new MetadataSourceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSource");
            SoftwareCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "getMetadataSource");
            response.setElement((MetadataSourceElement)handler.getBeanFromRepository(userId, metadataSourceGUID, "metadataSourceGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, false, false, new Date(), "getMetadataSource"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getMetadataSource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addUserProfileManagerClassification(String serverName, String userId, String metadataSourceGUID, NullRequestBody requestBody) {
        String methodName = "addUserProfileManagerClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addUserProfileManagerClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addUserProfileManagerClassification");
            SoftwareCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "addUserProfileManagerClassification");
            handler.addSoftwareCapabilityClassification(userId, null, null, metadataSourceGUID, "metadataSourceGUID", OpenMetadataType.USER_PROFILE_MANAGER.typeName, null, null, true, false, false, new Date(), "addUserProfileManagerClassification");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addUserProfileManagerClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addUserAccessDirectoryClassification(String serverName, String userId, String metadataSourceGUID, NullRequestBody requestBody) {
        String methodName = "addUserAccessDirectoryClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addUserAccessDirectoryClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addUserAccessDirectoryClassification");
            SoftwareCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "addUserAccessDirectoryClassification");
            handler.addSoftwareCapabilityClassification(userId, null, null, metadataSourceGUID, "metadataSourceGUID", OpenMetadataType.USER_ACCESS_DIRECTORY.typeName, null, null, true, false, false, new Date(), "addUserAccessDirectoryClassification");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addUserAccessDirectoryClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addMasterDataManagerClassification(String serverName, String userId, String metadataSourceGUID, NullRequestBody requestBody) {
        String methodName = "addMasterDataManagerClassification";
        String metadataSourceGUIDParameterName = "metadataSourceGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addMasterDataManagerClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addMasterDataManagerClassification");
            SoftwareCapabilityHandler<MetadataSourceElement> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "addMasterDataManagerClassification");
            handler.addSoftwareCapabilityClassification(userId, null, null, metadataSourceGUID, "metadataSourceGUID", OpenMetadataType.MASTER_DATA_MANAGER.typeName, null, null, true, false, false, new Date(), "addMasterDataManagerClassification");
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addMasterDataManagerClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

