/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommunitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommunityResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.CommunityHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CommunityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.communities.CommunityMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.communities.CommunityProperties;
import org.slf4j.LoggerFactory;

public class CommunityRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CommunityRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createCommunity(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createCommunity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createCommunity");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCommunity");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "createCommunity");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof CommunityProperties) {
                    CommunityProperties properties = (CommunityProperties)referenceableProperties;
                    String communityGUID = handler.createCommunity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getName(), properties.getDescription(), properties.getMission(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createCommunity");
                    if (communityGUID != null) {
                        handler.setVendorProperties(userId, communityGUID, properties.getVendorProperties(), false, false, new Date(), "createCommunity");
                    }
                    response.setGUID(communityGUID);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommunityProperties.class.getName(), "createCommunity");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createCommunity", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createCommunity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createCommunityFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createCommunityFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createCommunityFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCommunityFromTemplate");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "createCommunityFromTemplate");
            if (requestBody != null) {
                String communityGUID = handler.createCommunityFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), "createCommunityFromTemplate");
                response.setGUID(communityGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createCommunityFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createCommunityFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCommunity(String serverName, String userId, String communityGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateCommunity";
        String communityGUIDParameterName = "communityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCommunity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCommunity");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "updateCommunity");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof CommunityProperties) {
                    CommunityProperties properties = (CommunityProperties)referenceableProperties;
                    handler.updateCommunity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), communityGUID, "communityGUID", properties.getQualifiedName(), properties.getName(), properties.getDescription(), properties.getMission(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateCommunity");
                    if (!isMergeUpdate || properties.getVendorProperties() != null) {
                        handler.setVendorProperties(userId, communityGUID, properties.getVendorProperties(), false, false, new Date(), "updateCommunity");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommunityProperties.class.getName(), "updateCommunity");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateCommunity", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateCommunity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCommunityRole(String serverName, String userId, String communityGUID, String communityRoleGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupCommunityRole";
        String communityGUIDParameterName = "communityGUID";
        String communityRoleGUIDParameterName = "communityRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupCommunityRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCommunityRole");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "setupCommunityRole");
            if (requestBody != null) {
                int ordinal = CommunityMembershipType.CONTRIBUTOR.getOrdinal();
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof CommunityMembershipProperties) {
                    CommunityMembershipProperties properties = (CommunityMembershipProperties)relationshipProperties;
                    if (properties.getMembershipType() != null) {
                        ordinal = properties.getMembershipType().getOrdinal();
                    }
                    handler.addRoleToCommunity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), communityGUID, "communityGUID", communityRoleGUID, "communityRoleGUID", ordinal, properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupCommunityRole");
                } else if (requestBody.getProperties() == null) {
                    handler.addRoleToCommunity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), communityGUID, "communityGUID", communityRoleGUID, "communityRoleGUID", ordinal, null, null, false, false, new Date(), "setupCommunityRole");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommunityMembershipProperties.class.getName(), "setupCommunityRole");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupCommunityRole", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupCommunityRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCommunityRole(String serverName, String userId, String communityGUID, String communityRoleGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearCommunityRole";
        String communityGUIDParameterName = "communityGUID";
        String communityRoleGUIDParameterName = "communityRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearCommunityRole");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCommunityRole");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "clearCommunityRole");
            if (requestBody != null) {
                handler.removeRoleFromCommunity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), communityGUID, "communityGUID", communityRoleGUID, "communityRoleGUID", false, false, new Date(), "clearCommunityRole");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearCommunityRole", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearCommunityRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommunity(String serverName, String userId, String communityGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeCommunity";
        String communityGUIDParameterName = "communityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeCommunity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeCommunity");
                CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "removeCommunity");
                handler.removeCommunity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), communityGUID, "communityGUID", false, false, new Date(), "removeCommunity");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeCommunity", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeCommunity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommunitiesResponse findCommunities(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findCommunities";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findCommunities");
        CommunitiesResponse response = new CommunitiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findCommunities");
            if (requestBody != null) {
                CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "findCommunities");
                List communities = handler.findCommunities(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findCommunities");
                response.setElements(this.setUpVendorProperties(userId, communities, handler, "findCommunities"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findCommunities", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findCommunities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommunitiesResponse getCommunitiesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getCommunitiesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCommunitiesByName");
        CommunitiesResponse response = new CommunitiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCommunitiesByName");
            if (requestBody != null) {
                CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "getCommunitiesByName");
                List communities = handler.getCommunitiesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getCommunitiesByName");
                response.setElements(this.setUpVendorProperties(userId, communities, handler, "getCommunitiesByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getCommunitiesByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCommunitiesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRolesResponse getRolesForCommunity(String serverName, String userId, String communityGUID, int startFrom, int pageSize) {
        String methodName = "getRolesForCommunity";
        String guidParameterName = "communityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRolesForCommunity");
        PersonRolesResponse response = new PersonRolesResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<ActorRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getRolesForCommunity");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRolesForCommunity");
            response.setElements(handler.getCommunityRoles(userId, communityGUID, "communityGUID", startFrom, pageSize, false, false, new Date(), "getRolesForCommunity"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRolesForCommunity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommunitiesResponse getCommunities(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getCommunities";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCommunities");
        CommunitiesResponse response = new CommunitiesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCommunities");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "getCommunities");
            List communities = handler.getCommunities(userId, startFrom, pageSize, false, false, new Date(), "getCommunities");
            response.setElements(this.setUpVendorProperties(userId, communities, handler, "getCommunities"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCommunities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommunityResponse getCommunityByGUID(String serverName, String userId, String guid) {
        String methodName = "getCommunityByGUID";
        String guidParameterName = "communityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCommunityByGUID");
        CommunityResponse response = new CommunityResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCommunityByGUID");
            CommunityHandler<CommunityElement> handler = instanceHandler.getCommunityHandler(userId, serverName, "getCommunityByGUID");
            CommunityElement community = (CommunityElement)handler.getCommunityByGUID(userId, guid, "communityGUID", false, false, new Date(), "getCommunityByGUID");
            response.setElement(this.setUpVendorProperties(userId, community, handler, "getCommunityByGUID"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCommunityByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<CommunityElement> setUpVendorProperties(String userId, List<CommunityElement> retrievedResults, CommunityHandler<CommunityElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (CommunityElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private CommunityElement setUpVendorProperties(String userId, CommunityElement element, CommunityHandler<CommunityElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            CommunityProperties properties = element.getProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

