/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LocationResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LocationsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.LocationHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LocationElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.AdjacentLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.AssetLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.DigitalLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.FixedLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.LocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.NestedLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.ProfileLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.SecureLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.slf4j.LoggerFactory;

public class LocationRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(LocationRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createLocation(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createLocation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createLocation");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createLocation");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "createLocation");
                if (requestBody.getProperties() instanceof LocationProperties) {
                    LocationProperties locationProperties = (LocationProperties)requestBody.getProperties();
                    response.setGUID(handler.createLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationProperties.getQualifiedName(), locationProperties.getIdentifier(), locationProperties.getDisplayName(), locationProperties.getDescription(), locationProperties.getAdditionalProperties(), locationProperties.getTypeName(), locationProperties.getExtendedProperties(), locationProperties.getEffectiveFrom(), locationProperties.getEffectiveTo(), new Date(), "createLocation"));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LocationProperties.class.getName(), "createLocation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createLocation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createLocationFromTemplate(String serverName, String userId, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createLocationFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createLocationFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createLocationFromTemplate");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "createLocationFromTemplate");
                response.setGUID(handler.createLocationFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), templateGUID, requestBody.getQualifiedName(), requestBody.getIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), "createLocationFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createLocationFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createLocationFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateLocation(String serverName, String userId, String locationGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateLocation";
        String guidParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "updateLocation");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof LocationProperties) {
                    LocationProperties locationProperties = (LocationProperties)requestBody.getProperties();
                    handler.updateLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", locationProperties.getQualifiedName(), locationProperties.getIdentifier(), locationProperties.getDisplayName(), locationProperties.getDescription(), locationProperties.getAdditionalProperties(), locationProperties.getTypeName(), locationProperties.getExtendedProperties(), isMergeUpdate, locationProperties.getEffectiveFrom(), locationProperties.getEffectiveTo(), false, false, new Date(), "updateLocation");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LocationProperties.class.getName(), "updateLocation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateLocation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocationAsFixedPhysical(String serverName, String userId, String locationGUID, ClassificationRequestBody requestBody) {
        String methodName = "setLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocationAsFixedPhysical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setLocationAsFixedPhysical");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setLocationAsFixedPhysical");
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof FixedLocationProperties) {
                    FixedLocationProperties properties = (FixedLocationProperties)classificationProperties;
                    handler.addFixedLocationClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", properties.getCoordinates(), properties.getMapProjection(), properties.getPostalAddress(), properties.getTimeZone(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setLocationAsFixedPhysical");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FixedLocationProperties.class.getName(), "setLocationAsFixedPhysical");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setLocationAsFixedPhysical", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setLocationAsFixedPhysical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocationAsFixedPhysical(String serverName, String userId, String locationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocationAsFixedPhysical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLocationAsFixedPhysical");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearLocationAsFixedPhysical");
            if (requestBody == null) {
                handler.removeFixedLocationClassification(userId, null, null, locationGUID, "locationGUID", false, false, new Date(), "clearLocationAsFixedPhysical");
            } else {
                handler.removeFixedLocationClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", false, false, new Date(), "clearLocationAsFixedPhysical");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearLocationAsFixedPhysical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocationAsSecure(String serverName, String userId, String locationGUID, ClassificationRequestBody requestBody) {
        String methodName = "setLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocationAsSecure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setLocationAsSecure");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setLocationAsSecure");
                if (requestBody.getProperties() instanceof SecureLocationProperties) {
                    SecureLocationProperties properties = (SecureLocationProperties)requestBody.getProperties();
                    handler.addSecureLocationClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", properties.getDescription(), properties.getLevel(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setLocationAsSecure");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SecureLocationProperties.class.getName(), "setLocationAsSecure");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setLocationAsSecure", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setLocationAsSecure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocationAsSecure(String serverName, String userId, String locationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocationAsSecure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLocationAsSecure");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearLocationAsSecure");
            if (requestBody == null) {
                handler.removeSecureLocationClassification(userId, null, null, locationGUID, "locationGUID", false, false, new Date(), "clearLocationAsSecure");
            } else {
                handler.removeSecureLocationClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", false, false, new Date(), "clearLocationAsSecure");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearLocationAsSecure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocationAsDigital(String serverName, String userId, String locationGUID, ClassificationRequestBody requestBody) {
        String methodName = "setLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocationAsDigital");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setLocationAsDigital");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setLocationAsDigital");
                if (requestBody.getProperties() instanceof DigitalLocationProperties) {
                    DigitalLocationProperties properties = (DigitalLocationProperties)requestBody.getProperties();
                    handler.addCyberLocationClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", properties.getNetworkAddress(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setLocationAsDigital");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(DigitalLocationProperties.class.getName(), "setLocationAsDigital");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setLocationAsDigital", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setLocationAsDigital", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocationAsDigital(String serverName, String userId, String locationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocationAsDigital");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLocationAsDigital");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearLocationAsDigital");
            if (requestBody == null) {
                handler.removeCyberLocationClassification(userId, null, null, locationGUID, "locationGUID", false, false, new Date(), "clearLocationAsDigital");
            } else {
                handler.removeCyberLocationClassification(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", false, false, new Date(), "clearLocationAsDigital");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearLocationAsDigital", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLocation(String serverName, String userId, String locationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeLocation";
        String guidParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "removeLocation");
            if (requestBody == null) {
                handler.removeLocation(userId, null, null, locationGUID, "locationGUID", false, false, new Date(), "removeLocation");
            } else {
                handler.removeLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", false, false, new Date(), "removeLocation");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupNestedLocation(String serverName, String userId, String parentLocationGUID, String childLocationGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupNestedLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupNestedLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setupNestedLocation");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof NestedLocationProperties) {
                    handler.setupNestedLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", requestBody.getProperties().getEffectiveFrom(), requestBody.getProperties().getEffectiveTo(), false, false, new Date(), "setupNestedLocation");
                } else if (requestBody.getProperties() == null) {
                    handler.setupNestedLocation(userId, null, null, parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", null, null, false, false, new Date(), "setupNestedLocation");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NestedLocationProperties.class.getName(), "setupNestedLocation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupNestedLocation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupNestedLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearNestedLocation(String serverName, String userId, String parentLocationGUID, String childLocationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearNestedLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearNestedLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearNestedLocation");
            if (requestBody == null) {
                handler.clearNestedLocation(userId, null, null, parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", false, false, new Date(), "clearNestedLocation");
            } else {
                handler.clearNestedLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", false, false, new Date(), "clearNestedLocation");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearNestedLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAdjacentLocation(String serverName, String userId, String locationOneGUID, String locationTwoGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAdjacentLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAdjacentLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setupAdjacentLocation");
            if (requestBody != null) {
                if (requestBody.getProperties() == null) {
                    handler.setupPeerLocations(userId, null, null, locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", null, null, false, false, new Date(), "setupAdjacentLocation");
                } else if (requestBody.getProperties() instanceof AdjacentLocationProperties) {
                    AdjacentLocationProperties properties = (AdjacentLocationProperties)requestBody.getProperties();
                    handler.setupPeerLocations(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupAdjacentLocation");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(AdjacentLocationProperties.class.getName(), "setupAdjacentLocation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAdjacentLocation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupAdjacentLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAdjacentLocation(String serverName, String userId, String locationOneGUID, String locationTwoGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAdjacentLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAdjacentLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearAdjacentLocation");
            if (requestBody == null) {
                handler.clearPeerLocations(userId, null, null, locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", false, false, new Date(), "clearAdjacentLocation");
            } else {
                handler.clearPeerLocations(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", false, false, new Date(), "clearAdjacentLocation");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAdjacentLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupProfileLocation(String serverName, String userId, String actorProfileGUID, String locationGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupProfileLocation";
        String actorProfileGUIDParameter = "actorProfileGUID";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupProfileLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupProfileLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setupProfileLocation");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof ProfileLocationProperties) {
                    ProfileLocationProperties properties = (ProfileLocationProperties)requestBody.getProperties();
                    handler.setupProfileLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), actorProfileGUID, "actorProfileGUID", locationGUID, "locationGUID", properties.getAssociationType(), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupProfileLocation");
                } else if (requestBody.getProperties() == null) {
                    handler.setupProfileLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), actorProfileGUID, "actorProfileGUID", locationGUID, "locationGUID", null, null, null, false, false, new Date(), "setupProfileLocation");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ProfileLocationProperties.class.getName(), "setupProfileLocation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupProfileLocation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupProfileLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearProfileLocation(String serverName, String userId, String actorProfileGUID, String locationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearProfileLocation";
        String actorProfileGUIDParameter = "actorProfileGUID";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearProfileLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearProfileLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearProfileLocation");
            if (requestBody == null) {
                handler.clearProfileLocation(userId, null, null, actorProfileGUID, "actorProfileGUID", locationGUID, "locationGUID", false, false, new Date(), "clearProfileLocation");
            } else {
                handler.clearProfileLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), actorProfileGUID, "actorProfileGUID", locationGUID, "locationGUID", false, false, new Date(), "clearProfileLocation");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearProfileLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssetLocation(String serverName, String userId, String assetGUID, String locationGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupAssetLocation";
        String assetGUIDParameter = "assetGUID";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssetLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssetLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setupAssetLocation");
            if (requestBody != null) {
                if (requestBody.getProperties() instanceof AssetLocationProperties) {
                    AssetLocationProperties properties = (AssetLocationProperties)requestBody.getProperties();
                    handler.setupAssetLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", assetGUID, "assetGUID", properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupAssetLocation");
                } else if (requestBody.getProperties() == null) {
                    handler.setupAssetLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", assetGUID, "assetGUID", null, null, false, false, new Date(), "setupAssetLocation");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(AssetLocationProperties.class.getName(), "setupAssetLocation");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAssetLocation", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupAssetLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetLocation(String serverName, String userId, String assetGUID, String locationGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearAssetLocation";
        String assetGUIDParameter = "assetGUID";
        String locationTwoGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearAssetLocation");
            if (requestBody == null) {
                handler.clearAssetLocation(userId, null, null, locationGUID, "locationGUID", assetGUID, "assetGUID", false, false, new Date(), "clearAssetLocation");
            } else {
                handler.clearAssetLocation(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), locationGUID, "locationGUID", assetGUID, "assetGUID", false, false, new Date(), "clearAssetLocation");
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearAssetLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse findLocations(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findLocations";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findLocations");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "findLocations");
                List locations = handler.findLocations(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findLocations");
                response.setElements(locations);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findLocations", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getLocationsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getLocationsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocationsByName");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocationsByName");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getLocationsByName");
                List locations = handler.getLocationsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getLocationsByName");
                response.setElements(locations);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getLocationsByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getLocationsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getAdjacentLocations(String serverName, String userId, String locationGUID, int startFrom, int pageSize) {
        String methodName = "getAdjacentLocations";
        String parameterName = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAdjacentLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAdjacentLocations");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getAdjacentLocations");
            List locations = handler.getAdjacentLocations(userId, locationGUID, "locationGUID", OpenMetadataType.LOCATION.typeName, startFrom, pageSize, false, false, new Date(), "getAdjacentLocations");
            response.setElements(locations);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAdjacentLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getNestedLocations(String serverName, String userId, String locationGUID, int startFrom, int pageSize) {
        String methodName = "getNestedLocations";
        String parameterName = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNestedLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNestedLocations");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getNestedLocations");
            List locations = handler.getNestedLocations(userId, locationGUID, "locationGUID", OpenMetadataType.LOCATION.typeName, startFrom, pageSize, false, false, new Date(), "getNestedLocations");
            response.setElements(locations);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getNestedLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getGroupingLocations(String serverName, String userId, String locationGUID, int startFrom, int pageSize) {
        String methodName = "getGroupingLocations";
        String parameterName = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGroupingLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGroupingLocations");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getGroupingLocations");
            List locations = handler.getGroupingLocations(userId, locationGUID, "locationGUID", OpenMetadataType.LOCATION.typeName, startFrom, pageSize, false, false, new Date(), "getGroupingLocations");
            response.setElements(locations);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGroupingLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getLocationsByProfile(String serverName, String userId, String actorProfileGUID, int startFrom, int pageSize) {
        String methodName = "getLocationsByProfile";
        String parameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocationsByProfile");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocationsByProfile");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getLocationsByProfile");
            List locations = handler.getProfileLocations(userId, actorProfileGUID, "actorProfileGUID", OpenMetadataType.ACTOR_PROFILE.typeName, startFrom, pageSize, false, false, new Date(), "getLocationsByProfile");
            response.setElements(locations);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getLocationsByProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getKnownLocationsForAsset(String serverName, String userId, String assetGUID, int startFrom, int pageSize) {
        String methodName = "getKnownLocationsForAsset";
        String parameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getKnownLocationsForAsset");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getKnownLocationsForAsset");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getKnownLocationsForAsset");
            List locations = handler.getAssetLocations(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, startFrom, pageSize, false, false, new Date(), "getKnownLocationsForAsset");
            response.setElements(locations);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getKnownLocationsForAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getLocations(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getLocations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocations");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getLocations");
            List locations = handler.getLocations(userId, startFrom, pageSize, false, false, new Date(), "getLocations");
            response.setElements(locations);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationResponse getLocationByGUID(String serverName, String userId, String locationGUID) {
        String methodName = "getLocationByGUID";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocationByGUID");
        LocationResponse response = new LocationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocationByGUID");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getLocationByGUID");
            LocationElement location = (LocationElement)handler.getBeanFromRepository(userId, locationGUID, "locationGUID", OpenMetadataType.LOCATION.typeName, false, false, new Date(), "getLocationByGUID");
            response.setElement(location);
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getLocationByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

