/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValueResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ValidValuesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueProperties;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static final CommunityProfileInstanceHandler instanceHandler = new CommunityProfileInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValue(String serverName, String userId, ReferenceableRequestBody requestBody) {
        String methodName = "createValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValue");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValue");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "createValidValue");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof ValidValueProperties) {
                    ValidValueProperties properties = (ValidValueProperties)referenceableProperties;
                    String validValueGUID = handler.createValidValue(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getCategory(), properties.getUsage(), properties.getScope(), properties.getIsDeprecated(), properties.getIsCaseSensitive(), properties.getPreferredValue(), properties.getDataType(), properties.getAdditionalProperties(), properties.getTypeName(), properties.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, "createValidValue"), properties.getEffectiveFrom(), properties.getEffectiveTo(), new Date(), "createValidValue");
                    if (validValueGUID != null) {
                        handler.setVendorProperties(userId, validValueGUID, properties.getVendorProperties(), false, false, new Date(), "createValidValue");
                    }
                    response.setGUID(validValueGUID);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueProperties.class.getName(), "createValidValue");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, boolean isMergeUpdate, ReferenceableRequestBody requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getProperties();
                if (referenceableProperties instanceof ValidValueProperties) {
                    ValidValueProperties properties = (ValidValueProperties)referenceableProperties;
                    handler.updateValidValue(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getCategory(), properties.getUsage(), properties.getScope(), properties.getIsDeprecated(), properties.getIsCaseSensitive(), properties.getPreferredValue(), properties.getDataType(), properties.getAdditionalProperties(), properties.getExtendedProperties(), instanceHandler.getSupportedZones(userId, serverName, "updateValidValue"), properties.getEffectiveFrom(), properties.getEffectiveTo(), isMergeUpdate, false, false, new Date(), "updateValidValue");
                    if (!isMergeUpdate || properties.getVendorProperties() != null) {
                        handler.setVendorProperties(userId, validValueGUID, properties.getVendorProperties(), false, false, new Date(), "updateValidValue");
                    }
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueProperties.class.getName(), "updateValidValue");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupValidValueMember(String serverName, String userId, String validValueSetGUID, String validValueMemberGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupValidValueMember";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupValidValueMember");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupValidValueMember");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "setupValidValueMember");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ValidValueMembershipProperties) {
                    ValidValueMembershipProperties properties = (ValidValueMembershipProperties)relationshipProperties;
                    handler.attachValidValueToSet(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueSetGUID, validValueMemberGUID, properties.getDefaultValue(), properties.getEffectiveFrom(), properties.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, "setupValidValueMember"), false, false, new Date(), "setupValidValueMember");
                } else if (requestBody.getProperties() == null) {
                    handler.attachValidValueToSet(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueSetGUID, validValueMemberGUID, false, null, null, instanceHandler.getSupportedZones(userId, serverName, "setupValidValueMember"), false, false, new Date(), "setupValidValueMember");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueMembershipProperties.class.getName(), "setupValidValueMember");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupValidValueMember", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupValidValueMember", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidValueMember(String serverName, String userId, String validValueSetGUID, String validValueMemberGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearValidValueMember";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidValueMember");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidValueMember");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "clearValidValueMember");
            if (requestBody != null) {
                handler.detachValidValueFromSet(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueSetGUID, validValueMemberGUID, false, false, new Date(), "clearValidValueMember");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearValidValueMember", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearValidValueMember", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupValidValues(String serverName, String userId, String elementGUID, String validValueGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupValidValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "setupValidValues");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ValidValueAssignmentProperties) {
                    ValidValueAssignmentProperties properties = (ValidValueAssignmentProperties)relationshipProperties;
                    handler.assignValidValueToConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, properties.getStrictRequirement(), properties.getEffectiveFrom(), properties.getEffectiveTo(), instanceHandler.getSupportedZones(userId, serverName, "setupValidValues"), false, false, new Date(), "setupValidValues");
                } else if (requestBody.getProperties() == null) {
                    handler.assignValidValueToConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, false, null, null, instanceHandler.getSupportedZones(userId, serverName, "setupValidValues"), false, false, new Date(), "setupValidValues");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ValidValueAssignmentProperties.class.getName(), "setupValidValues");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupValidValues", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearValidValues(String serverName, String userId, String elementGUID, String validValueGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearValidValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "clearValidValues");
            if (requestBody != null) {
                handler.unassignValidValueFromConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, false, false, new Date(), "clearValidValues");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearValidValues", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupReferenceValueTag(String serverName, String userId, String elementGUID, String validValueGUID, RelationshipRequestBody requestBody) {
        String methodName = "setupReferenceValueTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupReferenceValueTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupReferenceValueTag");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "setupReferenceValueTag");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof ReferenceValueAssignmentProperties) {
                    ReferenceValueAssignmentProperties properties = (ReferenceValueAssignmentProperties)relationshipProperties;
                    handler.assignReferenceValueToItem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, properties.getAttributeName(), properties.getConfidence(), properties.getSteward(), properties.getStewardTypeName(), properties.getStewardPropertyName(), properties.getNotes(), instanceHandler.getSupportedZones(userId, serverName, "setupReferenceValueTag"), properties.getEffectiveFrom(), properties.getEffectiveTo(), false, false, new Date(), "setupReferenceValueTag");
                } else if (requestBody.getProperties() == null) {
                    handler.assignReferenceValueToItem(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, null, 100, null, null, null, null, instanceHandler.getSupportedZones(userId, serverName, "setupReferenceValueTag"), null, null, false, false, new Date(), "setupReferenceValueTag");
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ReferenceValueAssignmentProperties.class.getName(), "setupReferenceValueTag");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupReferenceValueTag", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupReferenceValueTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearReferenceValueTag(String serverName, String userId, String elementGUID, String validValueGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "clearReferenceValueTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearReferenceValueTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearReferenceValueTag");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "clearReferenceValueTag");
            if (requestBody != null) {
                handler.unassignValidValueFromConsumer(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, elementGUID, false, false, new Date(), "clearReferenceValueTag");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearReferenceValueTag", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearReferenceValueTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeValidValue(String serverName, String userId, String validValueGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeValidValue");
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "removeValidValue");
                handler.deleteValidValue(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), validValueGUID, null, false, false, new Date(), "removeValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "removeValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse findValidValues(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findValidValues";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "findValidValues");
                List validValues = handler.findValidValues(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "findValidValues"), new Date(), "findValidValues");
                response.setElements(this.setUpVendorProperties(userId, validValues, handler, "findValidValues"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findValidValues", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValuesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getValidValuesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesByName");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesByName");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValuesByName");
                List validValues = handler.getValidValueByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValuesByName"), new Date(), "getValidValuesByName");
                response.setElements(this.setUpVendorProperties(userId, validValues, handler, "getValidValuesByName"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getValidValuesByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getValidValuesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String methodName = "getValidValueSetMembers";
        String guidParameterName = "validValueSetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValueSetMembers");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            response.setElements(handler.getValidValueSetMembers(userId, validValueSetGUID, "validValueSetGUID", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValueSetMembers"), new Date(), "getValidValueSetMembers"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getSetsForValidValue";
        String guidParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getSetsForValidValue");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            response.setElements(handler.getSetsForValidValue(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getSetsForValidValue"), new Date(), "getSetsForValidValue"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValuesForConsumer(String serverName, String userId, String elementGUID) {
        String methodName = "getValidValuesForConsumer";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesForConsumer");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesForConsumer");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValuesForConsumer");
            ValidValueElement validValue = (ValidValueElement)handler.getAssignedValidValues(userId, elementGUID, "elementGUID", false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValuesForConsumer"), new Date(), "getValidValuesForConsumer");
            response.setElement(this.setUpVendorProperties(userId, validValue, handler, "getValidValuesForConsumer"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getValidValuesForConsumer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getConsumersOfValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getConsumersOfValidValue";
        String guidParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConsumersOfValidValue");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getConsumersOfValidValue");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConsumersOfValidValue");
            response.setElements(handler.getValidValueConsumers(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, new Date(), "getConsumersOfValidValue"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getConsumersOfValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getReferenceValues(String serverName, String userId, String elementGUID, int startFrom, int pageSize) {
        String methodName = "getReferenceValues";
        String guidParameterName = "elementGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReferenceValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReferenceValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getReferenceValues");
            List validValue = handler.getReferenceValues(userId, elementGUID, "elementGUID", startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getReferenceValues"), new Date(), "getReferenceValues");
            response.setElements(this.setUpVendorProperties(userId, validValue, handler, "getReferenceValues"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getReferenceValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getAssigneesOfReferenceValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getAssigneesOfReferenceValue";
        String guidParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssigneesOfReferenceValue");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            ReferenceableHandler<RelatedElementStub> handler = instanceHandler.getRelatedElementHandler(userId, serverName, "getAssigneesOfReferenceValue");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssigneesOfReferenceValue");
            response.setElements(handler.getReferenceValueAssignees(userId, validValueGUID, "validValueGUID", startFrom, pageSize, false, false, new Date(), "getAssigneesOfReferenceValue"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAssigneesOfReferenceValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getAllValidValues(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getAllValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllValidValues");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getAllValidValues");
            List validValues = handler.getValidValues(userId, startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "getAllValidValues"), new Date(), "getAllValidValues");
            response.setElements(this.setUpVendorProperties(userId, validValues, handler, "getAllValidValues"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAllValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String guid) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler<ValidValueElement> handler = instanceHandler.getValidValueHandler(userId, serverName, "getValidValueByGUID");
            ValidValueElement validValue = (ValidValueElement)handler.getValidValueByGUID(userId, guid, false, false, instanceHandler.getSupportedZones(userId, serverName, "getValidValueByGUID"), new Date(), "getValidValueByGUID");
            response.setElement(this.setUpVendorProperties(userId, validValue, handler, "getValidValueByGUID"));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<ValidValueElement> setUpVendorProperties(String userId, List<ValidValueElement> retrievedResults, ValidValuesHandler<ValidValueElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (retrievedResults != null) {
            for (ValidValueElement element : retrievedResults) {
                if (element == null) continue;
                this.setUpVendorProperties(userId, element, handler, methodName);
            }
        }
        return retrievedResults;
    }

    private ValidValueElement setUpVendorProperties(String userId, ValidValueElement element, ValidValuesHandler<ValidValueElement> handler, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "element.getElementHeader().getGUID()";
        if (element != null) {
            ValidValueProperties properties = element.getValidValueProperties();
            properties.setVendorProperties(handler.getVendorProperties(userId, element.getElementHeader().getGUID(), "element.getElementHeader().getGUID()", false, false, new Date(), methodName));
        }
        return element;
    }
}

