/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import org.odpi.openmetadata.accessservices.communityprofile.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MyProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.MyProfileRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
public class MyProfileResource {
    private MyProfileRESTServices restAPI = new MyProfileRESTServices();

    @RequestMapping(method={RequestMethod.GET}, path={"/my-profile"})
    public PersonalProfileResponse getMyProfile(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getMyProfile(serverName, userId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/my-profile"})
    public VoidResponse updateMyProfile(@PathVariable String serverName, @PathVariable String userId, @RequestBody MyProfileRequestBody requestBody) {
        return this.restAPI.updateMyProfile(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/my-assets"})
    public AssetListResponse getMyAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMyAssets(serverName, userId, startFrom, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/my-assets/{assetGUID}"})
    public VoidResponse addToMyAssets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody nullRequestBody) {
        return this.restAPI.addToMyAssets(serverName, userId, assetGUID, nullRequestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/my-assets/{assetGUID}/delete"})
    public VoidResponse removeFromMyAssets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody NullRequestBody nullRequestBody) {
        return this.restAPI.removeFromMyAssets(serverName, userId, assetGUID, nullRequestBody);
    }
}

