/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.PersonalProfileRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
public class PersonalProfileResource {
    private PersonalProfileRESTServices restAPI = new PersonalProfileRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/personal-profiles"})
    public GUIDResponse createPersonalProfile(@PathVariable String serverName, @PathVariable String userId, @RequestBody PersonalProfileRequestBody requestBody) {
        return this.restAPI.createPersonalProfile(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/personal-profiles/{profileGUID}"})
    public VoidResponse updatePersonalProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileGUID, @RequestBody PersonalProfileRequestBody requestBody) {
        return this.restAPI.updatePersonalProfile(serverName, userId, profileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/personal-profiles/{profileGUID}/delete"})
    public VoidResponse deletePersonalProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileGUID, @RequestBody PersonalProfileValidatorRequestBody requestBody) {
        return this.restAPI.deletePersonalProfile(serverName, userId, profileGUID, requestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/user/{profileUserId}"})
    public PersonalProfileResponse getPersonalProfileForUser(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileUserId) {
        return this.restAPI.getPersonalProfileForUser(serverName, userId, profileUserId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/{profileGUID}"})
    public PersonalProfileResponse getPersonalProfileByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileGUID) {
        return this.restAPI.getPersonalProfileByGUID(serverName, userId, profileGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/by-employee-number/{employeeNumber}"})
    public PersonalProfileResponse getPersonalProfileByEmployeeNumber(@PathVariable String serverName, @PathVariable String userId, @PathVariable String employeeNumber) {
        return this.restAPI.getPersonalProfileByQualifiedName(serverName, userId, employeeNumber);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/personal-profiles/by-name/{name}"})
    public PersonalProfileListResponse getPersonalProfilesByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getPersonalProfilesByName(serverName, userId, name, startFrom, pageSize);
    }
}

