/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ActorProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ContactMethodRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.EffectiveDatesRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonRoleResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TeamPlayerRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.OrganizationRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Community Profile Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class OrganizationResource {
    private final OrganizationRESTServices restAPI = new OrganizationRESTServices();

    @PostMapping(path={"/profiles"})
    public GUIDResponse createActorProfile(@PathVariable String serverName, @PathVariable String userId, @RequestBody ActorProfileRequestBody requestBody) {
        return this.restAPI.createActorProfile(serverName, userId, requestBody);
    }

    @PostMapping(path={"/profiles/{actorProfileGUID}"})
    public VoidResponse updateActorProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID, @RequestParam boolean isMergeUpdate, @RequestBody ActorProfileRequestBody requestBody) {
        return this.restAPI.updateActorProfile(serverName, userId, actorProfileGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/profiles/{actorProfileGUID}/delete"})
    public VoidResponse deleteActorProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteActorProfile(serverName, userId, actorProfileGUID, requestBody);
    }

    @PostMapping(path={"/profiles/{actorProfileGUID}/contact-methods"})
    public GUIDResponse addContactMethod(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID, @RequestBody ContactMethodRequestBody requestBody) {
        return this.restAPI.addContactMethod(serverName, userId, actorProfileGUID, requestBody);
    }

    @PostMapping(path={"/profiles/contact-methods/{contactMethodGUID}/delete"})
    public VoidResponse deleteContactMethod(@PathVariable String serverName, @PathVariable String userId, @PathVariable String contactMethodGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteContactMethod(serverName, userId, contactMethodGUID, requestBody);
    }

    @PostMapping(path={"/profiles/{superTeamProfileGUID}/sub-team-profiles/{subTeamProfileGUID}/link"})
    public VoidResponse linkTeamsInHierarchy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String superTeamProfileGUID, @PathVariable String subTeamProfileGUID, @RequestParam boolean delegationEscalationAuthority, @RequestBody EffectiveDatesRequestBody requestBody) {
        return this.restAPI.linkTeamsInHierarchy(serverName, userId, superTeamProfileGUID, subTeamProfileGUID, delegationEscalationAuthority, requestBody);
    }

    @PostMapping(path={"/profiles/{superTeamProfileGUID}/sub-team-profiles/{subTeamProfileGUID}/unlink"})
    public VoidResponse unlinkTeamsInHierarchy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String superTeamProfileGUID, @PathVariable String subTeamProfileGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.unlinkTeamsInHierarchy(serverName, userId, superTeamProfileGUID, subTeamProfileGUID, requestBody);
    }

    @GetMapping(path={"/profiles/{actorProfileGUID}"})
    public ActorProfileResponse getActorProfileByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID) {
        return this.restAPI.getActorProfileByGUID(serverName, userId, actorProfileGUID);
    }

    @GetMapping(path={"/profiles/user-ids/{actorProfileUserId}"})
    public ActorProfileResponse getActorProfileByUserId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileUserId) {
        return this.restAPI.getActorProfileByUserId(serverName, userId, actorProfileUserId);
    }

    @GetMapping(path={"/profiles"})
    public ActorProfileListResponse getActorProfiles(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActorProfiles(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/profiles/locations/{locationGUID}"})
    public ActorProfileListResponse getActorProfilesByLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActorProfilesByLocation(serverName, userId, locationGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/profiles/by-name"})
    public ActorProfileListResponse getActorProfilesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getActorProfilesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/profiles/by-search-string"})
    public ActorProfileListResponse findActorProfile(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findActorProfiles(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/person-roles"})
    public GUIDResponse createPersonRole(@PathVariable String serverName, @PathVariable String userId, @RequestBody PersonRoleRequestBody requestBody) {
        return this.restAPI.createPersonRole(serverName, userId, requestBody);
    }

    @PostMapping(path={"/person-roles/{personRoleGUID}"})
    public VoidResponse updatePersonRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID, @RequestParam boolean isMergeUpdate, @RequestBody PersonRoleRequestBody requestBody) {
        return this.restAPI.updatePersonRole(serverName, userId, personRoleGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/person-roles/{personRoleGUID}/delete"})
    public VoidResponse deletePersonRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.deletePersonRole(serverName, userId, personRoleGUID, requestBody);
    }

    @PostMapping(path={"/person-roles/{personRoleGUID}/profiles/{personProfileGUID}/link"})
    public GUIDResponse linkPersonRoleToProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID, @PathVariable String personProfileGUID, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.linkPersonRoleToProfile(serverName, userId, personRoleGUID, personProfileGUID, requestBody);
    }

    @PostMapping(path={"/person-roles/{personRoleGUID}/appointees"})
    public PersonRoleAppointeeListResponse getAppointees(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeRequestBody requestBody) {
        return this.restAPI.getAppointees(serverName, userId, personRoleGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/person-roles/appointees/{appointmentGUID}"})
    public VoidResponse updateAppointment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String appointmentGUID, @RequestParam boolean isMergeUpdate, @RequestBody AppointmentRequestBody requestBody) {
        return this.restAPI.updateAppointment(serverName, userId, appointmentGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/person-roles/appointees/{appointmentGUID}/unlink"})
    public VoidResponse unlinkPersonRoleFromProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String appointmentGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.unlinkPersonRoleFromProfile(serverName, userId, appointmentGUID, requestBody);
    }

    @PostMapping(path={"/team-profiles/{teamProfileGUID}/team-roles/{teamRoleGUID}/link"})
    public VoidResponse linkTeamPlayer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String teamRoleGUID, @PathVariable String teamProfileGUID, @RequestBody TeamPlayerRequestBody requestBody) {
        return this.restAPI.linkTeamPlayer(serverName, userId, teamRoleGUID, teamProfileGUID, requestBody);
    }

    @PostMapping(path={"/team-profiles/{teamProfileGUID}/team-roles/{teamRoleGUID}/unlink"})
    public VoidResponse unlinkTeamPlayer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String teamRoleGUID, @PathVariable String teamProfileGUID, @RequestBody TeamPlayerRequestBody requestBody) {
        return this.restAPI.unlinkTeamPlayer(serverName, userId, teamRoleGUID, teamProfileGUID, requestBody);
    }

    @GetMapping(path={"/person-roles/{personRoleGUID}"})
    public PersonRoleResponse getPersonRoleByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID) {
        return this.restAPI.getPersonRoleByGUID(serverName, userId, personRoleGUID);
    }

    @PostMapping(path={"/person-roles/by-name"})
    public PersonRoleListResponse getPersonRoleByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getPersonRoleByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/person-roles/by-team/{teamGUID}/leadership"})
    public PersonRoleListResponse getLeadershipRolesForTeam(@PathVariable String serverName, @PathVariable String userId, @PathVariable String teamGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLeadershipRolesForTeam(serverName, userId, teamGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/person-roles/by-team/{teamGUID}/membership"})
    public PersonRoleListResponse getMembershipRolesForTeam(@PathVariable String serverName, @PathVariable String userId, @PathVariable String teamGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMembershipRolesForTeam(serverName, userId, teamGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/person-roles/by-search-string"})
    public PersonRoleListResponse findPersonRole(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findPersonRoles(serverName, userId, startFrom, pageSize, requestBody);
    }
}

