/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.PersonalProfileRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Community Profile Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class PersonalProfileResource {
    private final PersonalProfileRESTServices restAPI = new PersonalProfileRESTServices();

    @PostMapping(path={"/personal-profiles"})
    public GUIDResponse createPersonalProfile(@PathVariable String serverName, @PathVariable String userId, @RequestBody PersonalProfileRequestBody requestBody) {
        return this.restAPI.createPersonalProfile(serverName, userId, requestBody);
    }

    @PostMapping(path={"/personal-profiles/{profileGUID}"})
    public VoidResponse updatePersonalProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileGUID, @RequestBody PersonalProfileRequestBody requestBody) {
        return this.restAPI.updatePersonalProfile(serverName, userId, profileGUID, requestBody);
    }

    @PostMapping(path={"/personal-profiles/{profileGUID}/delete"})
    public VoidResponse deletePersonalProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileGUID, @RequestBody PersonalProfileValidatorRequestBody requestBody) {
        return this.restAPI.deletePersonalProfile(serverName, userId, profileGUID, requestBody);
    }

    @GetMapping(path={"/personal-profiles/user/{profileUserId}"})
    public PersonalProfileResponse getPersonalProfileForUser(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileUserId) {
        return this.restAPI.getPersonalProfileForUser(serverName, userId, profileUserId);
    }

    @GetMapping(path={"/personal-profiles/{profileGUID}"})
    public PersonalProfileResponse getPersonalProfileByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String profileGUID) {
        return this.restAPI.getPersonalProfileByGUID(serverName, userId, profileGUID);
    }

    @PostMapping(path={"/personal-profiles/by-qualified-name"})
    public PersonalProfileResponse getPersonalProfileByQualifiedName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getPersonalProfileByQualifiedName(serverName, userId, requestBody);
    }

    @PostMapping(path={"/personal-profiles/by-name"})
    public PersonalProfileListResponse getPersonalProfilesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getPersonalProfilesByName(serverName, userId, startFrom, pageSize, requestBody);
    }
}

