/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.UserIdentityResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.UserIdentityRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Community Profile Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class UserIdentityResource {
    private final UserIdentityRESTServices restAPI = new UserIdentityRESTServices();

    @PostMapping(path={"/user-identities"})
    public GUIDResponse createUserIdentity(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createUserIdentity(serverName, userId, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}"})
    public VoidResponse updateUserIdentity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateUserIdentity(serverName, userId, userIdentityGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/delete"})
    public VoidResponse deleteUserIdentity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.deleteUserIdentity(serverName, userId, userIdentityGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/profiles/{profileGUID}/link"})
    public VoidResponse addIdentityToProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.addIdentityToProfile(serverName, userId, userIdentityGUID, profileGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/profiles/{profileGUID}/link/update"})
    public VoidResponse updateIdentityProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestParam boolean isMergeUpdate, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.updateIdentityProfile(serverName, userId, userIdentityGUID, profileGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/profiles/{profileGUID}/unlink"})
    public VoidResponse removeIdentityFromProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeIdentityFromProfile(serverName, userId, userIdentityGUID, profileGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/by-search-string"})
    public UserIdentityListResponse findUserIdentities(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findUserIdentities(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/user-identities/by-name"})
    public UserIdentityListResponse getUserIdentitiesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getUserIdentitiesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/user-identities/{userIdentityGUID}"})
    public UserIdentityResponse getUserIdentityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID) {
        return this.restAPI.getUserIdentityByGUID(serverName, userId, userIdentityGUID);
    }
}

