/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.properties.SecurityGroupProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.SecurityGroupResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.SecurityGroupsResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.SecurityGroupRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Community Profile Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/community-profile/overview/"))
public class SecurityGroupResource {
    private SecurityGroupRESTServices restAPI = new SecurityGroupRESTServices();

    @PostMapping(value={"/security-groups"})
    public GUIDResponse createSecurityGroup(@PathVariable String serverName, @PathVariable String userId, @RequestBody SecurityGroupProperties requestBody) {
        return this.restAPI.createSecurityGroup(serverName, userId, requestBody);
    }

    @PostMapping(value={"/security-groups/{securityGroupGUID}/update"})
    public VoidResponse updateSecurityGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID, @RequestParam boolean isMergeUpdate, @RequestBody SecurityGroupProperties requestBody) {
        return this.restAPI.updateSecurityGroup(serverName, userId, securityGroupGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(value={"/security-groups/{securityGroupGUID}/delete"})
    public VoidResponse deleteSecurityGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteSecurityGroup(serverName, userId, securityGroupGUID, requestBody);
    }

    @GetMapping(value={"/security-groups/for-distinguished-name/{distinguishedName}"})
    public SecurityGroupsResponse getSecurityGroupsForDistinguishedName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String distinguishedName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSecurityGroupsForDistinguishedName(serverName, userId, distinguishedName, startFrom, pageSize);
    }

    @GetMapping(value={"/security-groups/{securityGroupGUID}/governed-by/elements"})
    public ElementStubsResponse getElementsGovernedBySecurityGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getElementsGovernedBySecurityGroup(serverName, userId, securityGroupGUID, startFrom, pageSize);
    }

    @PostMapping(value={"/security-groups/by-search-string"})
    public SecurityGroupsResponse findSecurityGroups(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSecurityGroups(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(value={"/security-groups/{securityGroupGUID}"})
    public SecurityGroupResponse getSecurityGroupByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID) {
        return this.restAPI.getSecurityGroupByGUID(serverName, userId, securityGroupGUID);
    }
}

