/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.properties.MetadataSourceProperties;
import org.odpi.openmetadata.accessservices.communityprofile.rest.MetadataSourceResponse;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityProfileRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Community Profile Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class CommunityProfileResource {
    private CommunityProfileRESTServices restAPI = new CommunityProfileRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/metadata-sources"})
    public GUIDResponse createMetadataSource(@PathVariable String serverName, @PathVariable String userId, @RequestBody MetadataSourceProperties requestBody) {
        return this.restAPI.createMetadataSource(serverName, userId, requestBody);
    }

    @GetMapping(path={"/metadata-sources/by-name/{qualifiedName}"})
    public GUIDResponse getMetadataSourceGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getMetadataSourceGUID(serverName, userId, qualifiedName);
    }

    @GetMapping(path={"/metadata-sources/{metadataSourceGUID}"})
    public MetadataSourceResponse getMetadataSource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataSourceGUID) {
        return this.restAPI.getMetadataSource(serverName, userId, metadataSourceGUID);
    }

    @PostMapping(path={"/metadata-sources/{metadataSourceGUID}/user-profile-manager"})
    public VoidResponse addUserProfileManagerClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataSourceGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addUserProfileManagerClassification(serverName, userId, metadataSourceGUID, requestBody);
    }

    @PostMapping(path={"/metadata-sources/{metadataSourceGUID}/user-access-directory"})
    public VoidResponse addUserAccessDirectoryClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataSourceGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addUserAccessDirectoryClassification(serverName, userId, metadataSourceGUID, requestBody);
    }

    @PostMapping(path={"/metadata-sources/{metadataSourceGUID}/master-data-manager"})
    public VoidResponse addMasterDataManagerClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataSourceGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addMasterDataManagerClassification(serverName, userId, metadataSourceGUID, requestBody);
    }
}

