/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.communityprofile.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.RelatedElementRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Community Profile Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class RelatedElementsResource {
    private final RelatedElementRESTServices restAPI = new RelatedElementRESTServices();

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}"})
    public VoidResponse setupMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/more-information/{detailGUID}/delete"})
    public VoidResponse clearMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String detailGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearMoreInformation(serverName, userId, elementGUID, detailGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/more-information/by-descriptive-element/{elementGUID}"})
    public RelatedElementListResponse getMoreInformation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getMoreInformation(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/more-information/by-detail-element/{detailGUID}"})
    public RelatedElementListResponse getDescriptiveElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String detailGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getDescriptiveElements(serverName, userId, detailGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}"})
    public VoidResponse setupStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/stakeholders/{stakeholderGUID}/delete"})
    public VoidResponse clearStakeholder(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String stakeholderGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearStakeholder(serverName, userId, elementGUID, stakeholderGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-commissioned-element/{elementGUID}"})
    public RelatedElementListResponse getStakeholders(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholders(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/stakeholders/by-stakeholder/{stakeholderGUID}"})
    public RelatedElementListResponse getStakeholderCommissionedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String stakeholderGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getStakeholderCommissionedElements(serverName, userId, stakeholderGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/assignment-scopes/{scopeGUID}"})
    public VoidResponse setupAssignmentScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String scopeGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAssignmentScope(serverName, userId, elementGUID, scopeGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/assignment-scopes/{scopeGUID}/delete"})
    public VoidResponse clearAssignmentScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String scopeGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearAssignmentScope(serverName, userId, elementGUID, scopeGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/assignment-scopes/by-assigned-actor/{elementGUID}"})
    public RelatedElementListResponse getAssignedScopes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssignedScopes(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/assignment-scopes/by-assigned-scope/{scopeGUID}"})
    public RelatedElementListResponse getAssignedActors(@PathVariable String serverName, @PathVariable String userId, @PathVariable String scopeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAssignedActors(serverName, userId, scopeGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}"})
    public VoidResponse setupResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{elementGUID}/resource-list/{resourceGUID}/delete"})
    public VoidResponse clearResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String resourceGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearResource(serverName, userId, elementGUID, resourceGUID, requestBody);
    }

    @GetMapping(path={"/related-elements/resource-list/by-assignee/{elementGUID}"})
    public RelatedElementListResponse getResourceList(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getResourceList(serverName, userId, elementGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/related-elements/resource-list/by-resource/{resourceGUID}"})
    public RelatedElementListResponse getSupportedByResource(@PathVariable String serverName, @PathVariable String userId, @PathVariable String resourceGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSupportedByResource(serverName, userId, resourceGUID, startFrom, pageSize);
    }
}

